<?php

namespace wbb\data\post;

/**
 * Represents a simplified version of ViewablePostList.
 * Disables the loading of attachment, polls, embedded objects, modification log entries by default.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Posts
 */
class SimplifiedViewablePostList extends ViewablePostList
{
    /**
     * @inheritDoc
     */
    protected $pollLoading = false;

    /**
     * @inheritDoc
     */
    protected $modificationLogLoading = false;

    /**
     * @inheritDoc
     */
    protected $embeddedObjectLoading = true;
}
