<?php

namespace wbb\page;

use wbb\data\board\WatchedBoardNodeList;
use wbb\system\WBBCore;
use wcf\page\AbstractPage;
use wcf\system\WCF;

/**
 * Shows the list of watched boards.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Page
 * @since   5.0
 */
class WatchedBoardListPage extends AbstractPage
{
    /**
     * @inheritDoc
     */
    public $loginRequired = true;

    /**
     * list of watched board nodes
     * @var WatchedBoardNodeList
     */
    public $boardNodeList;

    /**
     * @inheritDoc
     */
    public function assignVariables()
    {
        parent::assignVariables();

        WCF::getTPL()->assign('boardNodeList', $this->boardNodeList->getNodeList());
    }

    /**
     * @inheritDoc
     */
    public function readData()
    {
        parent::readData();

        $this->boardNodeList = new WatchedBoardNodeList();
        $this->boardNodeList->readNodeTree();

        // add breadcrumbs
        WBBCore::getInstance()->setLocation();
    }
}
