<?php

namespace wbb\system\importer;

use wbb\data\post\Post;
use wbb\data\post\PostEditor;
use wcf\data\object\type\ObjectTypeCache;
use wcf\system\importer\AbstractAttachmentImporter;
use wcf\system\importer\ImportHandler;

/**
 * Imports post attachments.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Importer
 */
class AttachmentImporter extends AbstractAttachmentImporter
{
    /**
     * Creates a new AttachmentImporter object.
     */
    public function __construct()
    {
        $objectType = ObjectTypeCache::getInstance()
            ->getObjectTypeByName('com.woltlab.wcf.attachment.objectType', 'com.woltlab.wbb.post');
        $this->objectTypeID = $objectType->objectTypeID;
    }

    /**
     * @inheritDoc
     */
    public function import($oldID, array $data, array $additionalData = [])
    {
        $data['objectID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.post', $data['objectID']);
        if (!$data['objectID']) {
            return 0;
        }

        $attachmentID = parent::import($oldID, $data, $additionalData);
        if ($attachmentID && $attachmentID != $oldID) {
            // fix embedded attachments
            $post = new Post($data['objectID']);

            if (($newMessage = $this->fixEmbeddedAttachments($post->message, $oldID, $attachmentID)) !== false) {
                $editor = new PostEditor($post);
                $editor->update([
                    'message' => $newMessage,
                ]);
            }
        }

        return $attachmentID;
    }
}
