<?php

/**
 * Update the subscriptions to the new format.
 *
 * @author Joshua Ruesweg
 * @copyright 2001-2022 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum
 */

use wcf\system\user\collapsible\content\UserCollapsibleContentHandler;
use wcf\system\WCF;

$objectTypeID = UserCollapsibleContentHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.ignoredBoard');

$sql = "SELECT  COUNT(*)
        FROM    wcf1_user_collapsible_content
        WHERE   objectTypeID = ?";
$statement = WCF::getDB()->prepare($sql);
$statement->execute([
    $objectTypeID,
]);

if ($statement->fetchSingleColumn() > 0) {
    // First: Delete all entries in wbb1_board_user_status, to avoid problems if an update will be run twice.
    $sql = "DELETE FROM     wbb1_board_user_status
            WHERE           status = ?";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute([
        'ignoring',
    ]);

    // Second: Convert all watched threads into the new format.
    $sql = "INSERT INTO wbb1_board_user_status
                        (userID, boardID, status)
            SELECT      userID, objectID, 'ignoring'
            FROM        wcf1_user_collapsible_content
            WHERE       objectTypeID = ?
                    AND objectID IN (
                        SELECT  boardID
                        FROM    wbb1_board
                    )";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute([
        $objectTypeID,
    ]);

    // Third: Delete all entries in wcf1_user_collapsible_content, because they are no longer needeed.
    $sql = "DELETE FROM wcf1_user_collapsible_content
            WHERE       objectTypeID = ?";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute([
        $objectTypeID,
    ]);
}
