<?php

namespace wbb\data\thread;

use wbb\system\thread\status\ThreadStatusHandler;
use wcf\system\exception\IllegalLinkException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\exception\UserInputException;

/**
 * Executes thread status related actions.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2021 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread
 * @since 5.5
 */
final class ThreadStatusAction extends ThreadAction
{
    public function validateSaveSubscriptionStatus(): void
    {
        $this->readInteger('threadID');
        $this->readString('status');

        $thread = new Thread($this->parameters['threadID']);

        if (!$thread->threadID) {
            throw new IllegalLinkException();
        }

        if (!$thread->canRead()) {
            throw new PermissionDeniedException();
        }

        if ($thread->getBoard()->isIgnored()) {
            throw new IllegalLinkException();
        }

        if (
            !\in_array($this->parameters['status'], [
                ThreadStatusHandler::SUBSCRIPTION_MODE_NORMAL,
                ThreadStatusHandler::SUBSCRIPTION_MODE_WATCHING,
                ThreadStatusHandler::SUBSCRIPTION_MODE_IGNORING,
            ])
        ) {
            throw new UserInputException('status');
        }

        if (
            $this->parameters['status'] === ThreadStatusHandler::SUBSCRIPTION_MODE_IGNORING
            && !$thread->getBoard()->isIgnorable()
        ) {
            throw new PermissionDeniedException();
        }
    }

    public function saveSubscriptionStatus()
    {
        ThreadStatusHandler::saveSubscriptionStatus(
            [$this->parameters['threadID']],
            $this->parameters['status']
        );

        return [
            'status' => $this->parameters['status'],
            'threadID' => $this->parameters['threadID'],
        ];
    }
}
