<?php

namespace wbb\data\thread\form\option;

use wcf\data\custom\option\CustomOptionEditor;
use wcf\data\IEditableCachedObject;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\WCF;

/**
 * Provides functions to edit contact recipients.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread\Form\Option
 * @since   5.2
 *
 *
 * @method static   ThreadFormOption    create(array $parameters = [])
 * @method      ThreadFormOption    getDecoratedObject()
 * @mixin       ThreadFormOption
 */
class ThreadFormOptionEditor extends CustomOptionEditor implements IEditableCachedObject
{
    /**
     * @inheritDoc
     */
    protected static $baseClass = ThreadFormOption::class;

    /**
     * @inheritDoc
     */
    public static function resetCache()
    {
        ThreadFormCache::getInstance()->resetCache();
    }

    /**
     * Sets the show order of the thread form option.
     *
     * @param   int                             $showOrder
     * @param       PreparedStatementConditionBuilder       $conditionBuilder
     */
    public function setShowOrder($showOrder, PreparedStatementConditionBuilder $conditionBuilder)
    {
        $sql = "SELECT  MAX(showOrder)
                FROM    wbb" . WCF_N . "_thread_form_option " . $conditionBuilder;
        $statement = WCF::getDB()->prepareStatement($sql);
        $statement->execute($conditionBuilder->getParameters());
        $maxShowOrder = $statement->fetchSingleColumn();
        if (!$maxShowOrder) {
            $maxShowOrder = 0;
        }

        if (!$showOrder || $showOrder > $maxShowOrder) {
            $newShowOrder = $maxShowOrder + 1;
        } else {
            $conditionBuilder->add('showOrder >= ?', [$showOrder]);
            // shift other ads
            $sql = "UPDATE  wbb" . WCF_N . "_thread_form_option
                    SET     showOrder = showOrder + 1
                    " . $conditionBuilder;
            $statement = WCF::getDB()->prepareStatement($sql);
            $statement->execute($conditionBuilder->getParameters());

            $newShowOrder = $showOrder;
        }

        $this->update([
            'showOrder' => $newShowOrder,
        ]);
    }
}
