<?php

namespace wbb\system\bbcode;

use wbb\data\thread\ViewableThread;
use wcf\system\bbcode\AbstractBBCode;
use wcf\system\bbcode\BBCodeParser;
use wcf\system\message\embedded\object\MessageEmbeddedObjectManager;
use wcf\system\request\LinkHandler;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 * Parses the [thread] bbcode tag.
 *
 * @author      Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package     WoltLabSuite\Forum\System\Bbcode
 * @since       5.2
 */
class ThreadBBCode extends AbstractBBCode
{
    /**
     * @inheritDoc
     */
    public function getParsedTag(array $openingTag, $content, array $closingTag, BBCodeParser $parser)
    {
        $objectID = 0;
        if (isset($openingTag['attributes'][0])) {
            $objectID = \intval($openingTag['attributes'][0]);
        }

        /** @var ViewableThread $object */
        $object = MessageEmbeddedObjectManager::getInstance()->getObject('com.woltlab.wbb.thread', $objectID);
        if ($object !== null && $object->canRead()) {
            if ($parser->getOutputType() == 'text/html') {
                return WCF::getTPL()->fetch('threadBBCode', 'wbb', [
                    'thread' => $object,
                    'threadID' => $object->threadID,
                    'titleHash' => \substr(StringUtil::getRandomID(), 0, 8),
                ], true);
            } else {
                return StringUtil::getAnchorTag(LinkHandler::getInstance()->getLink('Thread', [
                    'application' => 'wbb',
                    'id' => $object->threadID,
                ]), $object->getTitle());
            }
        }

        return StringUtil::getAnchorTag(LinkHandler::getInstance()->getLink('Thread', [
            'application' => 'wbb',
            'id' => $objectID,
        ]));
    }
}
