<?php

namespace wbb\system\board;

use wcf\system\SingletonFactory;
use wcf\system\WCF;

/**
 * Handles individual permissions for boards.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Board
 */
class BoardPermissionHandler extends SingletonFactory
{
    /**
     * list of permissions
     * @var array
     */
    protected $boardPermissions = [];

    /**
     * list of mod permissions
     * @var array
     */
    protected $moderatorPermissions = [];

    /**
     * @inheritDoc
     */
    protected function init()
    {
        $this->boardPermissions = BoardPermissionCache::getInstance()->getPermissions(WCF::getUser());
        if (WCF::getUser()->userID) {
            $this->moderatorPermissions = BoardPermissionCache::getInstance()->getModeratorPermissions(WCF::getUser());
        }
    }

    /**
     * Returns the board permission with the given name for the board with the
     * given id.
     *
     * @param   int     $boardID
     * @param   string      $permission
     * @return  bool
     */
    public function getPermission($boardID, $permission)
    {
        if (isset($this->boardPermissions[$boardID][$permission])) {
            return $this->boardPermissions[$boardID][$permission];
        }

        return WCF::getSession()->getPermission('user.board.' . $permission);
    }

    /**
     * Returns the board moderator permission with the given name for the board
     * with the given id.
     *
     * @param   int     $boardID
     * @param   string      $permission
     * @return  bool
     */
    public function getModeratorPermission($boardID, $permission)
    {
        if (isset($this->moderatorPermissions[$boardID][$permission])) {
            return $this->moderatorPermissions[$boardID][$permission];
        }

        return WCF::getSession()->getPermission('mod.board.' . $permission);
    }
}
