<?php

namespace wbb\system\page\handler;

use wbb\data\board\BoardCache;
use wbb\data\thread\ViewableThread;
use wcf\system\page\handler\AbstractMenuPageHandler;

/**
 * Provides the number of unread threads for menu display.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Page\Handler
 * @since   5.0
 */
class BoardListPageHandler extends AbstractMenuPageHandler
{
    /**
     * @inheritDoc
     */
    public function getOutstandingItemCount($objectID = null)
    {
        return ViewableThread::getUnreadThreads();
    }

    /**
     * @inheritDoc
     * @since   5.2
     */
    public function isVisible($objectID = null)
    {
        foreach (BoardCache::getInstance()->getBoards() as $board) {
            if ($board->getPermission()) {
                return true;
            }
        }

        return false;
    }
}
