<?php

namespace wbb\acp\page;

use wbb\data\rss\feed\RssFeedList;
use wcf\page\SortablePage;

/**
 * Lists the available RSS feeds.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Acp\Page
 */
class RssFeedListPage extends SortablePage
{
    /**
     * @inheritDoc
     */
    public $activeMenuItem = 'wbb.acp.menu.link.rssFeed.list';

    /**
     * @inheritDoc
     */
    public $defaultSortField = 'title';

    /**
     * @inheritDoc
     */
    public $neededPermissions = ['admin.board.canManageRssFeed'];

    /**
     * @inheritDoc
     */
    public $objectListClassName = RssFeedList::class;

    /**
     * @inheritDoc
     */
    public $validSortFields = ['feedID', 'title', 'lastRun'];
}
