<?php

namespace wbb\data\thread;

/**
 * Represents a list of similar threads.
 *
 * @author  Marcel Werk
 * @copyright   2001-2021 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread
 */
class SimilarThreadList extends ViewableThreadList
{
    /**
     * @inheritDoc
     */
    public $sqlLimit = WBB_THREAD_SIMILAR_THREADS_COUNT;

    /**
     * @inheritDoc
     */
    public $sqlOrderBy = 'thread.lastPostTime DESC';

    /**
     * @inheritDoc
     */
    public $useQualifiedShorthand = false;

    /** @noinspection PhpMissingParentConstructorInspection */

    /**
     * Creates a new SimilarThreadList object.
     */
    public function __construct()
    {
        ThreadList::__construct();

        $this->sqlJoins = $this->sqlConditionJoins = "
            LEFT JOIN   wbb" . WCF_N . "_thread thread
            ON          thread.threadID = thread_similar.similarThreadID";

        if (!empty($this->sqlSelects)) {
            $this->sqlSelects .= ',';
        }
        $this->sqlSelects .= 'thread.*';
    }

    /**
     * @inheritDoc
     */
    public function readObjectIDs()
    {
        // does nothing
    }

    /**
     * @inheritDoc
     */
    public function getDatabaseTableName()
    {
        return 'wbb' . WCF_N . '_thread_similar';
    }

    /**
     * @inheritDoc
     */
    public function getDatabaseTableAlias()
    {
        return 'thread_similar';
    }
}
