<?php

namespace wbb\data\thread;

use wbb\data\board\Board;
use wbb\system\thread\status\ThreadStatusHandler;

/**
 * Represents a list of watched threads.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread
 */
class WatchedThreadList extends ViewableThreadList
{
    /**
     * Creates a new WatchedThreadList object.
     */
    public function __construct()
    {
        parent::__construct();

        $boardIDs = Board::getAccessibleBoardIDs();
        $privateBoardIDs = Board::getPrivateBoardIDs();
        if (empty($boardIDs) && empty($privateBoardIDs)) {
            $this->getConditionBuilder()->add('1=0');
        } else {
            $this->getConditionBuilder()->add('thread_user_status.status = ?', [
                ThreadStatusHandler::SUBSCRIPTION_MODE_WATCHING,
            ]);

            $this->applyBoardFilter();
        }
    }
}
