<?php

namespace wbb\system\event\listener;

use wbb\page\BoardPage;
use wbb\page\ThreadPage;
use wcf\data\page\PageCache;
use wcf\system\box\UserOnlineListBoxController;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\request\RequestHandler;
use wcf\system\WCF;

/**
 * Adds the forum stats in the statistics box.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 */
class UserOnlineListBoxControllerListener implements IParameterizedEventListener
{
    /**
     * @inheritDoc
     */
    public function execute($eventObj, $className, $eventName, array &$parameters)
    {
        /** @var UserOnlineListBoxController $eventObj */

        if (WCF::getActivePage() !== null) {
            $requestObject = RequestHandler::getInstance()->getActiveRequest()->getRequestObject();
            if (WBB_BOARD_USERS_ONLINE_FILTER && $requestObject instanceof BoardPage) {
                $eventObj->showRecord = false;
                $eventObj->title = WCF::getLanguage()->get('wbb.board.usersOnline');
                $eventObj->objectList->getConditionBuilder()->add(
                    '((session.pageID = ? AND session.pageObjectID = ?) OR (session.parentPageID = ? AND session.parentPageObjectID = ?))',
                    [
                        PageCache::getInstance()->getPageByIdentifier('com.woltlab.wbb.Board')->pageID,
                        $requestObject->boardID,
                        PageCache::getInstance()->getPageByIdentifier('com.woltlab.wbb.Board')->pageID,
                        $requestObject->boardID,
                    ]
                );
            } elseif (WBB_THREAD_USERS_ONLINE_FILTER && $requestObject instanceof ThreadPage) {
                $eventObj->showRecord = false;
                $eventObj->title = WCF::getLanguage()->get('wbb.thread.usersOnline');
                $eventObj->objectList->getConditionBuilder()->add(
                    'session.pageID = ?',
                    [PageCache::getInstance()->getPageByIdentifier('com.woltlab.wbb.Thread')->pageID]
                );
                $eventObj->objectList->getConditionBuilder()->add('session.pageObjectID = ?', [$requestObject->threadID]);
            }
        }
    }
}
