<?php

namespace wbb\system\importer;

use wbb\data\post\Post;
use wbb\data\post\PostEditor;
use wcf\data\object\type\ObjectTypeCache;
use wcf\system\importer\AbstractPollImporter;
use wcf\system\importer\ImportHandler;

/**
 * Imports polls.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Importer
 */
class PollImporter extends AbstractPollImporter
{
    /**
     * @inheritDoc
     */
    protected $objectTypeName = 'com.woltlab.wbb.poll';

    /**
     * Creates a new PollImporter object.
     */
    public function __construct()
    {
        $objectType = ObjectTypeCache::getInstance()
            ->getObjectTypeByName('com.woltlab.wcf.poll', 'com.woltlab.wbb.post');
        $this->objectTypeID = $objectType->objectTypeID;
    }

    /**
     * @inheritDoc
     */
    public function import($oldID, array $data, array $additionalData = [])
    {
        $data['objectID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.post', $data['objectID']);
        if (!$data['objectID']) {
            return 0;
        }

        $pollID = parent::import($oldID, $data);

        // update post
        $post = new PostEditor(new Post(null, ['postID' => $data['objectID']]));
        $post->update([
            'pollID' => $pollID,
        ]);

        return $pollID;
    }
}
