<?php

namespace wbb\system\thread\editor;

use wbb\data\thread\Thread;

/**
 * Default implementations for thread editors.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Thread\Editor
 */
abstract class AbstractThreadEditor implements IThreadEditor
{
    /**
     * current thread
     * @var Thread
     */
    public $thread;

    /**
     * @inheritDoc
     */
    public function setThread(Thread $thread)
    {
        $this->thread = $thread;
    }
}
