{include file='header' pageTitle='wbb.acp.rssFeed.'|concat:$action}

<script data-relocate="true" src="{@$__wcf->getPath()}js/WCF.Label.js"></script>
<script data-relocate="true">
	require([
		'WoltLabSuite/Core/Ui/ItemList',
		'WoltLabSuite/Forum/Controller/Thread/LabelCondition',
		'WoltLabSuite/Core/Ui/User/Search/Input',
	], (
		UIItemList,
		ControllerThreadLabelCondition,
		UiUserSearchInput
	) => {
		{if MODULE_TAGGING && WBB_THREAD_ENABLE_TAGS}
			UIItemList.init(
				'threadTags',
				[{if $threadTags|isset && $threadTags|count}{implode from=$threadTags item=tag}'{@$tag|encodeJS}'{/implode}{/if}],
				{
					ajax: {
						className: 'wcf\\data\\tag\\TagAction'
					},
					maxLength: {@TAGGING_MAX_TAG_LENGTH},
					submitFieldName: 'threadTags[]'
				}
			);
		{/if}
		
		new UiUserSearchInput(document.getElementById('username'));
		
		WCF.Language.addObject({
			'wcf.label.none': '{jslang}wcf.label.none{/jslang}',
		});
		
		new WCF.Label.Chooser({ {implode from=$labelIDs key=groupID item=labelID}{@$groupID}: {@$labelID}{/implode} }, '#formContainer');
		new ControllerThreadLabelCondition('boardID', { {implode from=$boardsToLabelGroups key=labelBoardID item=labelGroupIDs}{@$labelBoardID}: [ {implode from=$labelGroupIDs item=labelGroupID}{@$labelGroupID}{/implode} ]{/implode} });
	});
</script>

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.rssFeed.{$action}{/lang}</h1>
	</div>
	
	<nav class="contentHeaderNavigation">
		<ul>
			<li><a href="{link application='wbb' controller='RssFeedList'}{/link}" class="button"><span class="icon icon16 fa-list"></span> <span>{lang}wbb.acp.menu.link.rssFeed.list{/lang}</span></a></li>
			
			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{include file='formNotice'}

{if $action == 'edit' && $feed->errorMessage}
	<p class="warning">{lang}wbb.acp.rssFeed.errorMessage.info{/lang} {$feed->errorMessage}</p>
{/if}

{if $boardNodeList->hasChildren()}
	<form id="formContainer" method="post" action="{if $action == 'add'}{link application='wbb' controller='RssFeedAdd'}{/link}{else}{link application='wbb' controller='RssFeedEdit' id=$feed->feedID}{/link}{/if}">
		<section class="section">
			<h2 class="sectionTitle">{lang}wcf.global.form.data{/lang}</h2>
			
			<dl{if $errorField == 'title'} class="formError"{/if}>
				<dt><label for="title">{lang}wcf.global.title{/lang}</label></dt>
				<dd>
					<input type="text" id="title" name="title" value="{$title}" required autofocus class="long">
					{if $errorField == 'title'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wbb.acp.rssFeed.title.error.{$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>
			
			<dl{if $errorField == 'url'} class="formError"{/if}>
				<dt><label for="url">{lang}wbb.acp.rssFeed.url{/lang}</label></dt>
				<dd>
					<input type="url" id="url" name="url" value="{$url}" required class="long">
					{if $errorField == 'url'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wbb.acp.rssFeed.url.error.{$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}wbb.acp.rssFeed.url.description{/lang}</small>
				</dd>
			</dl>
			
			<dl{if $errorField == 'cycleTime'} class="formError"{/if}>
				<dt><label for="cycleTime">{lang}wbb.acp.rssFeed.cycleTime{/lang}</label></dt>
				<dd>
					<select name="cycleTime" id="cycleTime">
						<option value="600"{if $cycleTime == 600} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.600{/lang}</option>
						<option value="1200"{if $cycleTime == 1200} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.1200{/lang}</option>
						<option value="1800"{if $cycleTime == 1800} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.1800{/lang}</option>
						<option value="3600"{if $cycleTime == 3600} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.3600{/lang}</option>
						<option value="7200"{if $cycleTime == 7200} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.7200{/lang}</option>
						<option value="21600"{if $cycleTime == 21600} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.21600{/lang}</option>
						<option value="86400"{if $cycleTime == 86400} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.86400{/lang}</option>
						<option value="172800"{if $cycleTime == 172800} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.172800{/lang}</option>
						<option value="604800"{if $cycleTime == 604800} selected{/if}>{lang}wbb.acp.rssFeed.cycleTime.604800{/lang}</option>
					</select>
					{if $errorField == 'cycleTime'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wbb.acp.rssFeed.cycleTime.error.{$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}wbb.acp.rssFeed.cycleTime.description{/lang}</small>
				</dd>
			</dl>
			
			<dl{if $errorField == 'maxResults'} class="formError"{/if}>
				<dt><label for="maxResults">{lang}wbb.acp.rssFeed.maxResults{/lang}</label></dt>
				<dd>
					<input type="number" id="maxResults" name="maxResults" value="{$maxResults}" class="short" min="0" max="32767">
					{if $errorField == 'maxResults'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wbb.acp.rssFeed.maxResults.error.{$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}wbb.acp.rssFeed.maxResults.description{/lang}</small>
				</dd>
			</dl>
			
			<dl{if $errorField == 'searchKeywords'} class="formError"{/if}>
				<dt><label for="searchKeywords">{lang}wbb.acp.rssFeed.searchKeywords{/lang}</label></dt>
				<dd>
					<textarea name="searchKeywords" id="searchKeywords" rows="4" cols="60">{$searchKeywords}</textarea>
					{if $errorField == 'searchKeywords'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wbb.acp.rssFeed.searchKeywords.error.{$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}wbb.acp.rssFeed.searchKeywords.description{/lang}</small>
				</dd>
			</dl>
			
			{event name='dataFields'}
		</section>
		
		<section class="section">
			<h2 class="sectionTitle">{lang}wbb.acp.rssFeed.threadData{/lang}</h2>
			
			<dl{if $errorField == 'boardID'} class="formError"{/if}>
				<dt><label for="boardID">{lang}wbb.acp.rssFeed.board{/lang}</label></dt>
				<dd>
					<select name="boardID" id="boardID">
						<option value="0">{lang}wcf.global.noSelection{/lang}</option>
						{foreach from=$boardNodeList item=boardNode}
							{if !$boardNode->getBoard()->isExternalLink()}
								<option value="{@$boardNode->getBoard()->boardID}"{if $boardNode->getBoard()->isCategory()} disabled{elseif $boardNode->getBoard()->boardID == $boardID} selected{/if}>{if $boardNode->getDepth() > 1}{@"&nbsp;&nbsp;&nbsp;&nbsp;"|str_repeat:($boardNode->getDepth() - 1)}{/if}{$boardNode->getTitle()}</option>
							{/if}
						{/foreach}
						
					</select>
					{if $errorField == 'boardID'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wbb.acp.rssFeed.board.error.{$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}wbb.acp.rssFeed.board.description{/lang}</small>
				</dd>
			</dl>
			
			{if $multilingualismEnabled}
				<dl{if $errorField == 'languageID'} class="formError"{/if}>
					<dt><label for="languageID">{lang}wcf.user.language{/lang}</label></dt>
					<dd>
						<select name="languageID" id="languageID">
							<option value="0">{lang}wcf.global.noSelection{/lang}</option>
							{foreach from=$availableLanguages item=availableLanguage}
								<option value="{@$availableLanguage->languageID}"{if $availableLanguage->languageID == $languageID} selected{/if}>{$availableLanguage->languageName}</option>
							{/foreach}
							
						</select>
						{if $errorField == 'languageID'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{else}
									{lang}wbb.acp.rssFeed.language.error.{$errorType}{/lang}
								{/if}
							</small>
						{/if}
						<small>{lang}wbb.acp.rssFeed.language.description{/lang}</small>
					</dd>
				</dl>
			{/if}
			
			{if $labelGroups|count}
				{foreach from=$labelGroups item=labelGroup}
					{if $labelGroup|count}
						<dl{if $errorField == 'label' && $errorType[$labelGroup->groupID]|isset} class="formError"{/if}>
							<dt><label>{$labelGroup->getTitle()}</label></dt>
							<dd>
								<ul class="labelList" data-object-id="{@$labelGroup->groupID}" data-board-ids="[ {implode from=$labelGroupMapping[$labelGroup->groupID] item=boardID}{@$boardID}{/implode} ]">
									<li class="dropdown labelChooser" id="labelGroup{@$labelGroup->groupID}" data-group-id="{@$labelGroup->groupID}" data-force-selection="{if $labelGroup->forceSelection}true{else}false{/if}">
										<div class="dropdownToggle" data-toggle="labelGroup{@$labelGroup->groupID}"><span class="badge label">{lang}wcf.label.none{/lang}</span></div>
										<div class="dropdownMenu">
											<ul class="scrollableDropdownMenu">
												{foreach from=$labelGroup item=label}
													<li data-label-id="{@$label->labelID}"><span>{@$label->render()}</span></li>
												{/foreach}
											</ul>
										</div>
									</li>
								</ul>
								{if $errorField == 'label' && $errorType[$labelGroup->groupID]|isset}
									<small class="innerError">
										{if $errorType[$labelGroup->groupID] == 'missing'}
											{lang}wcf.label.error.missing{/lang}
										{else}
											{lang}wcf.label.error.invalid{/lang}
										{/if}
									</small>
								{/if}
							</dd>
						</dl>
					{/if}
				{/foreach}
			{/if}
			
			<dl{if $errorField == 'username'} class="formError"{/if}>
				<dt><label for="username">{lang}wcf.user.username{/lang}</label></dt>
				<dd>
					<input type="text" id="username" name="username" value="{$username}" required class="medium">
					{if $errorField == 'username'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wcf.user.username.error.{$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}wbb.acp.rssFeed.username.description{/lang}</small>
				</dd>
			</dl>
			
			{if MODULE_TAGGING && WBB_THREAD_ENABLE_TAGS}
				<dl{if $errorField == 'threadTags'} class="formError"{/if}>
					<dt><label for="threadTags">{lang}wbb.acp.rssFeed.threadTags{/lang}</label></dt>
					<dd>
						<div id="tagList" class="editableItemList"></div>
						<input type="text" id="threadTags" name="threadTags" value="" class="long">
						{if $errorField == 'threadTags'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{else}
									{lang}wbb.acp.rssFeed.threadTags.error.{$errorType}{/lang}
								{/if}
							</small>
						{/if}
						<small>{lang}wbb.acp.rssFeed.threadTags.description{/lang}</small>
					</dd>
				</dl>
				
				<dl>
					<dt></dt>
					<dd><label><input type="checkbox" name="useCategoriesAsTags" value="1"{if $useCategoriesAsTags} checked{/if}> {lang}wbb.acp.rssFeed.useCategoriesAsTags{/lang}</label></dd>
				</dl>
			{/if}
			
			<dl>
				<dt></dt>
				<dd>
					<label><input type="checkbox" name="closeThread" value="1"{if $closeThread} checked{/if}> {lang}wbb.acp.rssFeed.closeThread{/lang}</label>
					<label><input type="checkbox" name="disableThread" value="1"{if $disableThread} checked{/if}> {lang}wbb.acp.rssFeed.disableThread{/lang}</label>
				</dd>
			</dl>
			
			{event name='threadDataFields'}
		</section>
			
		{event name='sections'}
		
		<div class="formSubmit">
			<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
			{csrfToken}
		</div>
	</form>
{else}
	<p class="error">{lang}wbb.acp.rssFeed.error.noBoards{/lang}</p>
{/if}

{include file='footer'}
