<?php

namespace wbb\acp\form;

use wbb\data\board\Board;
use wbb\data\board\BoardList;
use wbb\data\thread\form\option\ThreadFormOptionList;
use wbb\data\thread\form\ThreadForm;
use wbb\data\thread\form\ThreadFormAction;
use wcf\acp\form\AbstractAcpForm;
use wcf\system\exception\IllegalLinkException;
use wcf\system\language\I18nHandler;
use wcf\system\WCF;

/**
 * Represents the thread form add form.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2020 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Acp\Form
 * @since   5.3
 */
class ThreadFormEditForm extends ThreadFormAddForm
{
    /**
     * @inheritDoc
     */
    public $activeMenuItem = 'wbb.acp.menu.link.threadForm.list';

    /**
     * @inheritDoc
     */
    public $action = 'edit';

    /**
     * form id
     * @var int
     */
    public $formID = 0;

    /**
     * ThreadForm object
     * @var ThreadForm
     */
    public $threadForm;

    /**
     * @inheritDoc
     */
    public function readParameters()
    {
        if (!empty($_REQUEST['id'])) {
            $this->formID = \intval($_REQUEST['id']);
        }
        $this->threadForm = new ThreadForm($this->formID);

        if (!$this->threadForm->formID) {
            throw new IllegalLinkException();
        }

        parent::readParameters();
    }

    /**
     * @inheritDoc
     */
    public function readData()
    {
        parent::readData();

        if (empty($_POST)) {
            $this->readDataI18n($this->threadForm);

            $this->title = $this->threadForm->title;

            $this->readThreadFormOptions();

            $boardList = new BoardList();
            $boardList->getConditionBuilder()->add('formID = ?', [$this->formID]);
            $boardList->getConditionBuilder()->add('boardType = ?', [Board::TYPE_BOARD]);
            $boardList->readObjectIDs();
            $this->boardIDs = $boardList->getObjectIDs();
        }
    }

    /**
     * @inheritDoc
     */
    protected function readThreadFormOptions()
    {
        $threadFormOptionList = new ThreadFormOptionList();
        $threadFormOptionList->getConditionBuilder()->add('formID = ?', [$this->formID]);
        $threadFormOptionList->sqlOrderBy = 'thread_form_option.showOrder ASC';
        $threadFormOptionList->readObjects();

        $this->threadFormOptions = \array_merge($this->threadFormOptions, $threadFormOptionList->getObjects());
    }

    /**
     * @inheritDoc
     */
    public function save()
    {
        AbstractAcpForm::save();

        $this->beforeSaveI18n($this->threadForm);

        $this->objectAction = new ThreadFormAction([$this->threadForm], 'update', [
            'data' => \array_merge($this->additionalFields, [
                'title' => $this->title,
            ]),
            'boardIDs' => $this->boardIDs,
        ]);
        $this->objectAction->executeAction();

        $this->saved();

        // show success message
        WCF::getTPL()->assign('success', true);
    }

    /**
     * @inheritDoc
     */
    public function assignVariables()
    {
        parent::assignVariables();

        I18nHandler::getInstance()->assignVariables(!empty($_POST));

        WCF::getTPL()->assign([
            'threadForm' => $this->threadForm,
        ]);
    }
}
