<?php

namespace wbb\data\post;

use wbb\data\thread\Thread;
use wcf\system\WCF;

/**
 * Represents a list of all posts in a thread.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Posts
 */
class ThreadPostList extends ViewablePostList
{
    /**
     * Creates a new ThreadPostList object.
     *
     * @param   Thread      $thread
     * @param   bool        $showDeletedPostNote
     */
    public function __construct(Thread $thread, $showDeletedPostNote = true)
    {
        parent::__construct();

        $this->setThread($thread);

        $this->getConditionBuilder()->add('post.threadID = ?', [$this->thread->threadID]);
        if (!$thread->getBoard()->getModeratorPermission('canEnablePost')) {
            if (WCF::getUser()->userID) {
                $this->getConditionBuilder()->add('(post.isDisabled = 0 OR post.userID = ?)', [WCF::getUser()->userID]);
            } else {
                $this->getConditionBuilder()->add('post.isDisabled = 0');
            }
        }
        if (
            (!$showDeletedPostNote || !WBB_THREAD_ENABLE_DELETED_POST_NOTE)
            && !$thread->getBoard()->getModeratorPermission('canReadDeletedPost')
        ) {
            $this->getConditionBuilder()->add('post.isDeleted = 0');
        }
    }
}
