<?php

namespace wbb\system\event\listener;

use wbb\data\board\BoardCache;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\WCF;

/**
 * Extends the daily system cleanup.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 */
class WBBCleanUpListener implements IParameterizedEventListener
{
    /**
     * @inheritDoc
     */
    public function execute($eventObj, $className, $eventName, array &$parameters)
    {
        // mark threads as done
        if (WBB_MODULE_THREAD_MARKING_AS_DONE && WBB_THREAD_MARKING_AS_DONE_CYCLE) {
            $boardIDs = [];
            foreach (BoardCache::getInstance()->getBoards() as $board) {
                if ($board->enableMarkingAsDone) {
                    $boardIDs[] = $board->boardID;
                }
            }

            if (!empty($boardIDs)) {
                $conditionBuilder = new PreparedStatementConditionBuilder();
                $conditionBuilder->add('boardID IN (?)', [$boardIDs]);
                $conditionBuilder->add('lastPostTime < ?', [TIME_NOW - WBB_THREAD_MARKING_AS_DONE_CYCLE * 86400]);

                $sql = "UPDATE  wbb" . WCF_N . "_thread
                        SET     isDone = 1
                        " . $conditionBuilder;
                $statement = WCF::getDB()->prepareStatement($sql);
                $statement->execute($conditionBuilder->getParameters());
            }
        }

        // delete move notices
        if (WBB_THREAD_DELETE_LINK_CYCLE) {
            $sql = "DELETE FROM wbb" . WCF_N . "_thread
                    WHERE       movedThreadID IS NOT NULL
                            AND movedTime > ?
                            AND movedTime < ?";
            $statement = WCF::getDB()->prepareStatement($sql);
            $statement->execute([0, TIME_NOW - WBB_THREAD_DELETE_LINK_CYCLE * 86400]);
        }

        // delete outdated thread form options
        $sql = "DELETE FROM wbb" . WCF_N . "_thread_form_option
                WHERE       formID IS NULL
                        AND timeCreated < ?";
        $statement = WCF::getDB()->prepareStatement($sql);
        $statement->execute([TIME_NOW - 86400]);
    }
}
