<?php

namespace wbb\system\label\object\type;

use wbb\data\board\BoardEditor;
use wbb\data\board\RealtimeBoardNodeList;
use wcf\system\label\object\type\AbstractLabelObjectTypeHandler;
use wcf\system\label\object\type\LabelObjectType;
use wcf\system\label\object\type\LabelObjectTypeContainer;

/**
 * Object type handler for boards.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Label\Object\Type
 */
class BoardLabelObjectTypeHandler extends AbstractLabelObjectTypeHandler
{
    /**
     * board node list
     * @var RealtimeBoardNodeList
     */
    public $boardNodeList;

    /**
     * object type id
     * @var int
     */
    public $objectTypeID = 0;

    /**
     * @inheritDoc
     */
    protected function init()
    {
        // get board list
        $this->boardNodeList = new RealtimeBoardNodeList();
        $this->boardNodeList->readNodeTree();
    }

    /**
     * @inheritDoc
     */
    public function setObjectTypeID($objectTypeID)
    {
        parent::setObjectTypeID($objectTypeID);

        // build label object type container
        $this->container = new LabelObjectTypeContainer($this->objectTypeID);

        foreach ($this->boardNodeList->getNodeList() as $boardNode) {
            // ignore links
            if ($boardNode->getBoard()->isExternalLink()) {
                continue;
            }

            $objectType = new LabelObjectType(
                $boardNode->getBoard()->getTitle(),
                $boardNode->getBoard()->boardID,
                $boardNode->getDepth() - 1,
                $boardNode->getBoard()->isCategory()
            );
            $this->container->add($objectType);
        }
    }

    /**
     * @inheritDoc
     */
    public function save()
    {
        BoardEditor::resetCache();
    }
}
