/**
 * Manager instance for posts.
 *
 * @author  Alexander Ebert
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Post/Manager
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Core", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Ui/Notification", "WoltLabSuite/Core/Ui/Message/Manager"], function (require, exports, tslib_1, Core, Language, UiNotification, Manager_1) {
    "use strict";
    Core = tslib_1.__importStar(Core);
    Language = tslib_1.__importStar(Language);
    UiNotification = tslib_1.__importStar(UiNotification);
    Manager_1 = tslib_1.__importDefault(Manager_1);
    class UiPostManager extends Manager_1.default {
        constructor(threadId) {
            super({
                className: "wbb\\data\\post\\PostAction",
                selector: ".wbbPost",
            });
            this.threadId = threadId;
            this.threadUpdateHandler = undefined;
        }
        setThreadUpdateHandler(threadUpdateHandler) {
            this.threadUpdateHandler = threadUpdateHandler;
        }
        update(objectId, actionName, parameters) {
            if (parameters.enableNote) {
                this.setNote(objectId, "wbbPostDelayedNote", parameters.enableNote);
            }
            else {
                super.update(objectId, actionName, parameters);
            }
        }
        /**
         * @see WoltLabSuite/Core/Ui/Message/Manager._updateState()
         */
        _updateState(element, propertyName, propertyValue, propertyValueBoolean) {
            super._updateState(element, propertyName, propertyValue, propertyValueBoolean);
            switch (propertyName) {
                case "deleted": {
                    const objectId = element.dataset.objectId;
                    this._elements.delete(objectId);
                    if (element.parentElement && element.parentElement.nodeName === "LI") {
                        element.parentElement.remove();
                    }
                    else {
                        element.remove();
                    }
                    break;
                }
                case "isClosed":
                    if (propertyValueBoolean) {
                        const listItem = document.createElement("li");
                        listItem.className = "wbbPostClosed";
                        const span = document.createElement("span");
                        span.classList.add("jsTooltip", "icon", "icon16", "fa-lock");
                        span.title = Language.get("wbb.post.closed");
                        listItem.appendChild(span);
                        const messageQuickOptions = element.querySelector(".messageQuickOptions");
                        messageQuickOptions === null || messageQuickOptions === void 0 ? void 0 : messageQuickOptions.insertAdjacentElement("afterbegin", listItem);
                    }
                    else {
                        const icon = element.querySelector(".wbbPostClosed");
                        icon === null || icon === void 0 ? void 0 : icon.remove();
                    }
                    break;
                case "isDeleted":
                    if (!propertyValueBoolean) {
                        const deleteNote = element.querySelector(".wbbPostDeleteNote");
                        deleteNote === null || deleteNote === void 0 ? void 0 : deleteNote.remove();
                    }
                    break;
            }
        }
        _ajaxSuccess(data) {
            var _a;
            Object.entries(data.returnValues.postData).forEach(([postId, postData]) => {
                const post = this._elements.get(postId);
                if (post === undefined) {
                    return;
                }
                this.updateItems([postId], postData);
            });
            if ((_a = data.returnValues.threadData) === null || _a === void 0 ? void 0 : _a[this.threadId]) {
                const threadData = data.returnValues.threadData[this.threadId];
                if (threadData.deleted) {
                    UiNotification.show(undefined, () => {
                        window.location.href = threadData.deleted;
                    });
                }
                else if (this.threadUpdateHandler) {
                    this.threadUpdateHandler.update(this.threadId, threadData);
                }
            }
        }
    }
    Core.enableLegacyInheritance(UiPostManager);
    return UiPostManager;
});
