/**
 * Shows a dialog overlay to create threads in unknown boards.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2021 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Board/GlobaleCreateThreadButton
 * @since 5.5
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ui/Dialog", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Ajax"], function (require, exports, tslib_1, Dialog_1, Language, Ajax_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.setup = exports.GlobalCreateThreadButton = void 0;
    Dialog_1 = tslib_1.__importDefault(Dialog_1);
    Language = tslib_1.__importStar(Language);
    class GlobalCreateThreadButton {
        constructor(button) {
            button.addEventListener("click", (event) => {
                event.preventDefault();
                void this.loadDialog();
            });
        }
        async loadDialog() {
            const response = (await (0, Ajax_1.dboAction)("createThreadBoardSelection", "wbb\\data\\board\\BoardAction").dispatch());
            this.openDialog(response.template);
        }
        openDialog(template) {
            Dialog_1.default.open(this, template);
        }
        _dialogSetup() {
            return {
                id: "wbbGlobalCreateThreadDialog",
                options: {
                    title: Language.get("wbb.index.selectForumForNewThread"),
                },
                source: null,
            };
        }
    }
    exports.GlobalCreateThreadButton = GlobalCreateThreadButton;
    function setup() {
        document.querySelectorAll(".globalCreateThreadButton").forEach((button) => {
            new GlobalCreateThreadButton(button);
        });
    }
    exports.setup = setup;
    exports.default = GlobalCreateThreadButton;
});
