/**
 * Shows similar threads when creating a new thread.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2021 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Thread/SimilarThreads
 * @since 5.5
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Dom/Util", "WoltLabSuite/Core/Ajax"], function (require, exports, tslib_1, Util_1, Ajax) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.SimilarThreads = void 0;
    Util_1 = tslib_1.__importDefault(Util_1);
    Ajax = tslib_1.__importStar(Ajax);
    class SimilarThreads {
        constructor(element, boardId) {
            this.element = element;
            this.boardId = boardId;
            this.element.addEventListener("change", () => this.search());
        }
        search() {
            const topic = this.element.value;
            const languageInput = document.querySelector("#languageIDContainer > input[name=languageID]");
            const languageID = languageInput ? parseInt(languageInput.value, 10) : null;
            if (topic.length > 3) {
                Ajax.api(this, {
                    parameters: {
                        boardID: this.boardId,
                        topic,
                        languageID,
                    },
                });
            }
            else {
                this.removeResults();
            }
        }
        removeResults() {
            var _a;
            (_a = document.querySelector(".wbbInlineSimilarThreadList")) === null || _a === void 0 ? void 0 : _a.remove();
        }
        _ajaxSuccess(data) {
            this.removeResults();
            if (data.returnValues.results) {
                const fragment = Util_1.default.createFragmentFromHtml(data.returnValues.template);
                this.element.parentElement.appendChild(fragment);
            }
        }
        _ajaxSetup() {
            return {
                data: {
                    actionName: "getSimilarThreads",
                    className: "wbb\\data\\thread\\ThreadAction",
                },
            };
        }
    }
    exports.SimilarThreads = SimilarThreads;
    exports.default = SimilarThreads;
});
