<?php

namespace wbb\system\message\embedded\object;

use wbb\data\thread\AccessibleThreadList;
use wcf\system\html\input\HtmlInputProcessor;
use wcf\system\message\embedded\object\AbstractMessageEmbeddedObjectHandler;
use wcf\system\WCF;

/**
 * Message embedded object handler implementation for threads.
 *
 * @author      Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package     WoltLabSuite\Forum\System\Message\Embedded
 */
class ThreadMessageEmbeddedObjectHandler extends AbstractMessageEmbeddedObjectHandler
{
    /**
     * @inheritDoc
     */
    public function loadObjects(array $objectIDs)
    {
        if (!WCF::getSession()->getPermission('user.board.canViewBoard')) {
            return [];
        }

        $objectList = new AccessibleThreadList();
        $objectList->getConditionBuilder()->add('thread.threadID IN (?)', [$objectIDs]);
        $objectList->readObjects();

        return $objectList->getObjects();
    }

    /**
     * @inheritDoc
     */
    public function parse(HtmlInputProcessor $htmlInputProcessor, array $embeddedData)
    {
        if (!WCF::getSession()->getPermission('user.board.canViewBoard')) {
            return [];
        }

        if (!empty($embeddedData['thread'])) {
            $objectIDs = [];
            for ($i = 0, $length = \count($embeddedData['thread']); $i < $length; $i++) {
                if (!empty($embeddedData['thread'][$i][0])) {
                    $objectIDs[] = \intval($embeddedData['thread'][$i][0]);
                }
            }

            if (!empty($objectIDs)) {
                $objectList = new AccessibleThreadList();
                $objectList->getConditionBuilder()->add('thread.threadID IN (?)', [$objectIDs]);
                $objectList->readObjectIDs();

                return $objectList->getObjectIDs();
            }
        }

        return [];
    }
}
