<?php

/**
 * Update the subscriptions to the new format.
 *
 * @author Joshua Ruesweg
 * @copyright 2001-2021 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum
 */

use wcf\system\user\object\watch\UserObjectWatchHandler;
use wcf\system\WCF;

$objectTypeID = UserObjectWatchHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.thread');

$sql = "SELECT  COUNT(*)
        FROM    wcf1_user_object_watch
        WHERE   objectTypeID = ?";
$statement = WCF::getDB()->prepare($sql);
$statement->execute([
    $objectTypeID,
]);

if ($statement->fetchSingleColumn() > 0) {
    // First: Delete all entries in wbb1_thread_status, to avoid problems if an update will be run twice.
    $sql = "DELETE FROM wbb1_thread_user_status";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute();

    // Second: Convert all watched threads into the new format.
    $sql = "INSERT INTO wbb1_thread_user_status
                        (userID, threadID, status)
            SELECT      userID, objectID, 'watching'
            FROM        wcf1_user_object_watch
            WHERE       objectTypeID = ?
                    AND objectID IN (
                        SELECT  threadID
                        FROM    wbb1_thread
                    )";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute([
        $objectTypeID,
    ]);

    // Third: Delete all entries in wcf1_user_object_watch, because they are no longer needeed.
    $sql = "DELETE FROM wcf1_user_object_watch
            WHERE       objectTypeID = ?";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute([
        $objectTypeID,
    ]);
}
