/**
 * Provides the thread form option add dialog.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Post/ThreadFormInline
 * @since       5.2
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Dom/Util", "WoltLabSuite/Core/Event/Handler", "WoltLabSuite/Core/Language"], function (require, exports, tslib_1, Ajax, Util_1, EventHandler, Language) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.registerElement = exports.init = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    Util_1 = tslib_1.__importDefault(Util_1);
    EventHandler = tslib_1.__importStar(EventHandler);
    Language = tslib_1.__importStar(Language);
    let _container;
    let _editorId;
    const _elements = new Map();
    function getFormElements() {
        const elements = {
            values: {},
        };
        _elements.forEach((data, elementId) => {
            const element = document.getElementById(elementId);
            if (element === null && data.elementRequired) {
                throw new Error(`[WoltLabSuite/Forum/Ui/Post/ThreadFormInline] Unable to locate given element '${elementId}'.`);
            }
            elements.values[elementId] = data.valueCallback(element);
        });
        return elements;
    }
    function validate(data) {
        data.promises.push(new Promise((resolve, reject) => {
            const post = _container.closest("article");
            const postId = ~~post.dataset.postId;
            Ajax.apiOnce({
                data: {
                    className: "wbb\\data\\post\\PostAction",
                    actionName: "validateThreadFormValues",
                    objectIDs: [postId],
                    parameters: getFormElements(),
                },
                success(data) {
                    const errors = Object.entries(data.returnValues.errors);
                    if (errors.length === 0) {
                        resolve();
                    }
                    else {
                        errors.forEach(([id, errorMessage]) => {
                            if (errorMessage === "empty") {
                                errorMessage = Language.get("wcf.global.form.error.empty");
                            }
                            else if (errorMessage === "validationFailed") {
                                errorMessage = Language.get("wcf.acp.customOption.error.validationFailed");
                            }
                            const element = document.getElementById(id);
                            Util_1.default.innerError(element, errorMessage);
                        });
                        window
                            .jQuery(`.messageTabMenu[data-wysiwyg-container-id='${_editorId}']`)
                            .messageTabMenu("showTab", "threadFormOptions", true);
                        reject();
                    }
                },
                failure() {
                    reject(new Error("[WoltLabSuite/Forum/Ui/Post/ThreadFormInline] Unable to validate thread form data due an unknown validate error."));
                    return false;
                },
            });
        }));
    }
    function submit(data) {
        data.threadFormOptions = getFormElements();
    }
    function init(containerId, editorId) {
        const container = document.getElementById(containerId);
        if (container === null) {
            throw new Error("[WoltLabSuite/Forum/Ui/Post/ThreadFormInline] Unable to locate given container.");
        }
        _container = container;
        _editorId = editorId;
        EventHandler.add("com.woltlab.wcf.redactor2", `submit_${_editorId}`, submit);
        EventHandler.add("com.woltlab.wcf.redactor2", `validate_${_editorId}`, validate);
    }
    exports.init = init;
    function registerElement(elementId, valueCallback, elementRequired = true) {
        if (typeof valueCallback !== "function") {
            valueCallback = (element) => element.value;
        }
        _elements.set(elementId, {
            valueCallback,
            elementRequired,
        });
    }
    exports.registerElement = registerElement;
});
