{include file='header' pageTitle='wbb.acp.menu.link.threadForm.list'}

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.menu.link.threadForm.list{/lang}</h1>
	</div>

	<nav class="contentHeaderNavigation">
		<ul>
			<li><a href="{link application='wbb' controller='ThreadFormAdd'}{/link}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.acp.menu.link.threadForm.add{/lang}</span></a></li>

			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{hascontent}
	<div class="paginationTop">
		{content}{pages print=true assign=pagesLinks application="wbb" controller="ThreadFormList" link="pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"}{/content}
	</div>
{/hascontent}

{if $objects|count}
	<div id="threadFormTableContainer" class="section tabularBox">
		<table class="table jsObjectActionContainer" data-object-action-class-name="wbb\data\thread\form\ThreadFormAction">
			<thead>
				<tr>
					<th class="columnID columnFormID{if $sortField == 'formID'} active {@$sortOrder}{/if}" colspan="2"><a href="{link application='wbb' controller='ThreadFormList'}pageNo={@$pageNo}&sortField=formID&sortOrder={if $sortField == 'formID' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.global.objectID{/lang}</a></th>
					<th class="columnTitle{if $sortField == 'title'} active {@$sortOrder}{/if}"><a href="{link application='wbb' controller='ThreadFormList'}pageNo={@$pageNo}&sortField=title&sortOrder={if $sortField == 'title' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.global.title{/lang}</a></th>
					
					{event name='columnHeads'}
				</tr>
			</thead>
			
			<tbody class="jsReloadPageWhenEmpty">
				{foreach from=$objects item=form}
					<tr class="jsThreadFormRow jsObjectActionObject" data-object-id="{@$form->getObjectID()}">
						<td class="columnIcon">
							<a href="{link application='wbb' controller='ThreadFormEdit' id=$form->formID}{/link}" title="{lang}wcf.global.button.edit{/lang}" class="jsTooltip"><span class="icon icon16 fa-pencil"></span></a>
							{objectAction action="delete" objectTitle=$form->getTitle()}
							
							{event name='rowButtons'}
						</td>
						<td class="columnID">{@$form->formID}</td>
						<td class="columnTitle">
							<a href="{link application='wbb' controller='ThreadFormEdit' id=$form->formID}{/link}">{$form->getTitle()}</a>
						</td>
						
						{event name='columns'}
					</tr>
				{/foreach}
			</tbody>
		</table>
	</div>
	
	<footer class="contentFooter">
		{hascontent}
			<div class="paginationBottom">
				{content}{@$pagesLinks}{/content}
			</div>
		{/hascontent}

		<nav class="contentFooterNavigation">
			<ul>
				<li><a href="{link application='wbb' controller='ThreadFormAdd'}{/link}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.acp.menu.link.threadForm.add{/lang}</span></a></li>

				{event name='contentFooterNavigation'}
			</ul>
		</nav>
	</footer>
{else}
	<p class="info">{lang}wcf.global.noItems{/lang}</p>
{/if}

{include file='footer'}
