<?php

namespace wbb\system\event\listener;

use wcf\system\event\listener\AbstractUserMergeListener;

/**
 * Updates posts, threads and rss feeds during user merging.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 */
class WBBUserMergeListener extends AbstractUserMergeListener
{
    /**
     * @inheritDoc
     */
    protected $databaseTables = [
        'wbb{WCF_N}_post',
        [
            'name' => 'wbb{WCF_N}_post',
            'userID' => 'editorID',
            'username' => 'editor',
        ],
        'wbb{WCF_N}_thread',
        [
            'name' => 'wbb{WCF_N}_thread',
            'userID' => 'lastPosterID',
            'username' => 'lastPoster',
        ],
        [
            'name' => 'wbb{WCF_N}_rss_feed',
            'username' => null,
        ],
    ];
}
