{capture assign='pageTitle'}{$__wcf->getActivePage()->getTitle()}{if $pageNo > 1} - {lang}wcf.page.pageNo{/lang}{/if}{/capture}

{capture assign='contentTitle'}{$__wcf->getActivePage()->getTitle()} <span class="badge">{#$items}</span>{/capture}

{capture assign='contentInteractionPagination'}
	{pages print=true assign=pagesLinks application='wbb' controller='WatchedThreadList' link="pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"}
{/capture}

{include file='header'}

{if $objects|count}
	<div class="section tabularBox messageGroupList wbbThreadList">
		<ol class="tabularList">
			<li class="tabularListRow tabularListRowHead">
				<ol class="tabularListColumns">
					<li class="columnMark jsOnly"><label><input type="checkbox" class="jsMarkAllWatchedThreads"></label></li>

					<li class="columnSort">
						<ul class="inlineList">
							<li>
								<a rel="nofollow" href="{link application='wbb' controller='WatchedThreadList'}pageNo={@$pageNo}&sortField={$sortField}&sortOrder={if $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">
									<span class="icon icon16 fa-sort-amount-{$sortOrder|strtolower} jsTooltip" title="{lang}wbb.board.sortBy{/lang} ({lang}wcf.global.sortOrder.{if $sortOrder === 'ASC'}ascending{else}descending{/if}{/lang})"></span>
								</a>
							</li>
							<li>
								<div class="dropdown">
									<span class="dropdownToggle">{lang}wbb.thread.{$sortField}{/lang}</span>

									<ul class="dropdownMenu">
										{foreach from=$validSortFields item=_sortField}
											<li{if $_sortField === $sortField} class="active"{/if}><a rel="nofollow" href="{link application='wbb' controller='WatchedThreadList'}pageNo={@$pageNo}&sortField={$_sortField}&sortOrder={if $sortField === $_sortField}{if $sortOrder === 'DESC'}ASC{else}DESC{/if}{else}{$sortOrder}{/if}{/link}">{lang}wbb.thread.{$_sortField}{/lang}</a></li>
										{/foreach}
									</ul>
								</div>
							</li>
						</ul>
					</li>
				</ol>
			</li>

			{include file='threadList' application='wbb' enableEditMode=false enableWatchMode=true}
		</ol>
	</div>
{else}
	<p class="info" role="status">{lang}wcf.global.noItems{/lang}</p>
{/if}

<footer class="contentFooter">
	{hascontent}
		<div class="paginationBottom">
			{content}{@$pagesLinks}{/content}
		</div>
	{/hascontent}

	{hascontent}
		<nav class="contentFooterNavigation">
			<ul>
				{content}
					{if $objects|count}
						<li class="jsOnly">
							<span id="stopWatchingButton" class="button">{lang}wbb.thread.watchedThreads.stopWatchingAll{/lang}</span>
						</li>
					{/if}

					{event name='contentFooterNavigation'}
				{/content}
			</ul>
		</nav>
	{/hascontent}
</footer>

<script data-relocate="true">
	require([
		'Language',
		'WoltLabSuite/Forum/Controller/Thread/WatchedList',
		'WoltLabSuite/Forum/Ui/Thread/MarkAsRead',
	], (
		Language,
		ControllerThreadWatchedList,
		ThreadMarkAsRead,
	) => {
		{if $objects|count}
			Language.addObject({
				'wbb.thread.watchedThreads.stopWatchingAll': '{jslang}wbb.thread.watchedThreads.stopWatchingAll{/jslang}',
				'wbb.thread.watchedThreads.stopWatchingAll.confirmMessage': '{jslang}wbb.thread.watchedThreads.stopWatchingAll.confirmMessage{/jslang}',
				'wbb.thread.watchedThreads.stopWatchingMarked': '{jslang __literal=true}wbb.thread.watchedThreads.stopWatchingMarked{/jslang}',
				'wbb.thread.watchedThreads.stopWatchingMarked.confirmMessage': '{jslang}wbb.thread.watchedThreads.stopWatchingMarked.confirmMessage{/jslang}',
			});

			ControllerThreadWatchedList.setup();
		{/if}

		ThreadMarkAsRead.setup();
	});
</script>

{include file='footer'}
