<?php

namespace wbb\data\post;

use wcf\system\edit\IHistorySavingObject;
use wcf\system\edit\IHistorySavingObjectTypeProvider;
use wcf\system\exception\InvalidObjectArgument;
use wcf\system\exception\PermissionDeniedException;

/**
 * Object type provider for history saving posts.
 *
 * @author  Tim Duesterhus
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Post
 *
 * @method  HistorySavingPost   getObjectByID($objectID)
 * @method  HistorySavingPost[] getObjectsByIDs(array $objectIDs)
 */
class HistorySavingPostProvider extends PostProvider implements IHistorySavingObjectTypeProvider
{
    /**
     * @inheritDoc
     */
    public $decoratorClassName = HistorySavingPost::class;

    /**
     * @inheritDoc
     */
    public function checkPermissions(IHistorySavingObject $object)
    {
        if (!($object instanceof HistorySavingPost)) {
            throw new InvalidObjectArgument($object, HistorySavingPost::class);
        }

        $thread = $object->getThread();
        if (!$thread->canEditPost($object->getDecoratedObject())) {
            throw new PermissionDeniedException();
        }
    }

    /**
     * @inheritDoc
     */
    public function getActivePageMenuItem()
    {
        return '';
    }
}
