<?php

namespace wbb\system\stat;

use wcf\system\stat\AbstractStatDailyHandler;

/**
 * Stat handler implementation for threads.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Stat
 */
class ThreadStatDailyHandler extends AbstractStatDailyHandler
{
    /**
     * @inheritDoc
     */
    public function getData($date)
    {
        return [
            'counter' => $this->getCounter($date, 'wbb' . WCF_N . '_thread', 'time'),
            'total' => $this->getTotal($date, 'wbb' . WCF_N . '_thread', 'time'),
        ];
    }
}
