<?php

namespace wbb\system\page\handler;

use wbb\system\thread\status\ThreadStatusHandler;
use wcf\system\page\handler\AbstractMenuPageHandler;

/**
 * Page handler for ignored thread list.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Page\Handler
 * @since   5.5
 */
final class IgnoredThreadListPageHandler extends AbstractMenuPageHandler
{
    use TThreadStatusPageHandler;

    /**
     * @inheritDoc
     */
    public function isVisible($objectID = null)
    {
        return $this->hasStatusThreads(ThreadStatusHandler::SUBSCRIPTION_MODE_IGNORING, 'wbbIgnoredThreads');
    }
}
