<?php

namespace wbb\system\user\notification\object\type;

use wbb\data\thread\Thread;
use wbb\data\thread\ThreadList;
use wbb\system\user\notification\object\ThreadUserNotificationObject;
use wcf\system\user\notification\object\type\AbstractUserNotificationObjectType;

/**
 * Notification object type implementation for threads.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\User\Notification\Object\Type
 * @since   5.0
 */
class ThreadUserNotificationObjectType extends AbstractUserNotificationObjectType
{
    /**
     * @inheritDoc
     */
    protected static $decoratorClassName = ThreadUserNotificationObject::class;

    /**
     * @inheritDoc
     */
    protected static $objectClassName = Thread::class;

    /**
     * @inheritDoc
     */
    protected static $objectListClassName = ThreadList::class;
}
