<?php

namespace wbb\data\board;

use wbb\system\board\status\BoardStatusHandler;
use wcf\system\exception\IllegalLinkException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\exception\UserInputException;

/**
 * Executes board status related actions.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2021 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Board
 * @since 5.5
 */
final class BoardStatusAction extends BoardAction
{
    public function validateSaveSubscriptionStatus(): void
    {
        $this->readInteger('boardID');
        $this->readString('status');

        $board = new Board($this->parameters['boardID']);

        if (!$board->boardID) {
            throw new IllegalLinkException();
        }

        if (!$board->canEnter()) {
            throw new PermissionDeniedException();
        }

        if (
            !\in_array($this->parameters['status'], [
                BoardStatusHandler::SUBSCRIPTION_MODE_NORMAL,
                BoardStatusHandler::SUBSCRIPTION_MODE_THREADSANDPOSTS,
                BoardStatusHandler::SUBSCRIPTION_MODE_IGNORING,
                BoardStatusHandler::SUBSCRIPTION_MODE_THREADSONLY,
            ])
        ) {
            throw new UserInputException('status');
        }

        if (!$board->isIgnorable() && $this->parameters['status'] == BoardStatusHandler::SUBSCRIPTION_MODE_IGNORING) {
            throw new PermissionDeniedException();
        }
    }

    public function saveSubscriptionStatus(): array
    {
        BoardStatusHandler::getInstance()->saveSubscriptionStatus(
            [$this->parameters['boardID']],
            $this->parameters['status']
        );

        return [
            'status' => $this->parameters['status'],
            'boardID' => $this->parameters['boardID'],
        ];
    }
}
