/**
 * Mobile optimizations for forum.
 *
 * @author  Alexander Ebert
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Mobile
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ui/Mobile", "WoltLabSuite/Core/Ui/Screen"], function (require, exports, tslib_1, UiMobile, UiScreen) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    UiMobile = tslib_1.__importStar(UiMobile);
    UiScreen = tslib_1.__importStar(UiScreen);
    function init() {
        const boardList = document.querySelector(".wbbBoardList");
        if (!boardList) {
            return;
        }
        const boards = boardList.getElementsByClassName("wbbBoardMain");
        UiScreen.on("screen-sm-down", {
            match: () => UiMobile.rebuildShadow(boards, ".containerHeadline > h3 > a"),
            unmatch: () => UiMobile.removeShadow(boards),
            setup: () => UiMobile.rebuildShadow(boards, ".containerHeadline > h3 > a"),
        });
    }
    exports.init = init;
});
