define(["require", "exports", "tslib", "WoltLabSuite/Core/Controller/Clipboard", "../InlineEditor", "../Manager"], function (require, exports, tslib_1, ControllerClipboard, InlineEditor_1, Manager_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    ControllerClipboard = tslib_1.__importStar(ControllerClipboard);
    InlineEditor_1 = tslib_1.__importDefault(InlineEditor_1);
    Manager_1 = tslib_1.__importDefault(Manager_1);
    function init() {
        // mixed lists do not offer editing capabilities
        const postManager = new Manager_1.default(0);
        new InlineEditor_1.default(0, postManager, { disableEdit: true });
        // we're pretending to be on the thread page and that there are marked items
        ControllerClipboard.setup({
            hasMarkedItems: true,
            pageClassName: "wbb\\page\\ThreadPage",
            pageObjectId: 0,
        });
        // TODO: Legacy component
        new window.WBB.Post.Clipboard(postManager);
    }
    exports.init = init;
});
