/**
 * Makes the thread form options sortable.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Sortable
 * @since       5.2
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Environment"], function (require, exports, tslib_1, Ajax, Environment) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    Environment = tslib_1.__importStar(Environment);
    /**
     * Add eventListeners to the thread option edit forms.
     */
    function rebuild() {
        if (Environment.platform() === "desktop") {
            new window.WCF.Sortable.List("threadFormOptions", "", 0, {
                axis: false,
                items: "li.sortableNode",
                toleranceElement: null,
                update: () => {
                    const threadFormOptions = document.getElementById("threadFormOptions");
                    const elements = threadFormOptions.querySelectorAll("li.sortableNode");
                    const optionIds = Array.from(elements).map((element) => ~~element.dataset.objectId);
                    if (optionIds.length) {
                        Ajax.apiOnce({
                            data: {
                                actionName: "updatePosition",
                                className: "wbb\\data\\thread\\form\\option\\ThreadFormOptionAction",
                                parameters: {
                                    optionIDs: optionIds,
                                },
                            },
                        });
                    }
                },
            }, true);
        }
    }
    function init() {
        rebuild();
    }
    exports.init = init;
});
