<?php

namespace wbb\system\user\notification\object;

use wbb\data\post\Post;
use wbb\system\cache\runtime\PostRuntimeCache;
use wcf\data\DatabaseObject;
use wcf\data\DatabaseObjectDecorator;
use wcf\data\modification\log\ModificationLog;
use wcf\system\user\notification\object\IUserNotificationObject;

/**
 * Represents a modification log post as a notification object.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\User\Notification\Object
 * @since   5.1
 *
 * @method  ModificationLog     getDecoratedObject()
 * @mixin   ModificationLog
 */
class PostModerationUserNotificationObject extends DatabaseObjectDecorator implements IUserNotificationObject
{
    /**
     * @inheritDoc
     */
    protected static $baseClass = ModificationLog::class;

    /**
     * @inheritDoc
     */
    public function __construct(DatabaseObject $object)
    {
        parent::__construct($object);

        PostRuntimeCache::getInstance()->cacheObjectID($this->getDecoratedObject()->objectID);
    }

    /**
     * @inheritDoc
     */
    public function getObjectID()
    {
        return $this->getDecoratedObject()->logID;
    }

    /**
     * @inheritDoc
     */
    public function getTitle()
    {
        return $this->getPost()->getTitle();
    }

    /**
     * @inheritDoc
     */
    public function getURL()
    {
        return $this->getPost()->getLink();
    }

    /**
     * @inheritDoc
     */
    public function getAuthorID()
    {
        if (WBB_THREAD_MODERATION_NOTIFICATION_SHOW_MODERATOR) {
            return $this->getDecoratedObject()->userID;
        }

        return 0;
    }

    /**
     * Returns the post object.
     *
     * @return Post
     */
    public function getPost()
    {
        return PostRuntimeCache::getInstance()->getObject($this->getDecoratedObject()->objectID);
    }
}
