<?php

namespace wbb\system\condition\thread;

use wbb\data\thread\Thread;
use wbb\page\IThreadPage;
use wcf\data\condition\Condition;
use wcf\system\condition\AbstractObjectTextPropertyCondition;
use wcf\system\condition\IContentCondition;
use wcf\system\request\RequestHandler;

/**
 * Condition implementation for the name of the user who created a thread.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Condition\Thread
 * @since   5.0
 */
class ThreadUsernameCondition extends AbstractObjectTextPropertyCondition implements IContentCondition
{
    /**
     * @inheritDoc
     */
    protected $className = Thread::class;

    /**
     * @inheritDoc
     */
    protected $description = 'wbb.thread.condition.username.description';

    /**
     * @inheritDoc
     */
    protected $fieldName = 'wbbThreadUsername';

    /**
     * @inheritDoc
     */
    protected $label = 'wbb.thread.condition.username';

    /**
     * @inheritDoc
     */
    protected $propertyName = 'username';

    /**
     * @inheritDoc
     */
    protected $supportsMultipleValues = true;

    /**
     * @inheritDoc
     */
    public function showContent(Condition $condition)
    {
        $requestObject = RequestHandler::getInstance()->getActiveRequest()->getRequestObject();
        if (!($requestObject instanceof IThreadPage)) {
            return false;
        }

        return $this->checkObject($requestObject->getThread(), $condition->conditionData);
    }
}
