<?php

namespace wbb\data\thread;

use wbb\data\board\BoardCache;
use wcf\data\search\ISearchResultObject;
use wcf\system\bbcode\KeywordHighlighter;
use wcf\system\request\LinkHandler;
use wcf\util\StringUtil;

/**
 * Represents a search result.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread
 */
class SearchResultThread extends ViewableThread implements ISearchResultObject
{
    /**
     * Return the highlighted topic.
     *
     * @return  string
     */
    public function getHighlightedTopic()
    {
        return KeywordHighlighter::getInstance()->doHighlight(StringUtil::encodeHTML($this->topic));
    }

    /**
     * @inheritDoc
     */
    public function getFormattedMessage()
    {
        return '';
    }

    /**
     * @inheritDoc
     */
    public function getSubject()
    {
        return $this->topic;
    }

    /**
     * @inheritDoc
     */
    public function getLink($query = '')
    {
        $parameters = [
            'application' => 'wbb',
            'object' => $this->getDecoratedObject(),
        ];

        if ($query) {
            $parameters['highlight'] = \urlencode($query);
        }

        return LinkHandler::getInstance()->getLink('Thread', $parameters);
    }

    /**
     * @inheritDoc
     */
    public function getTime()
    {
        return $this->time;
    }

    /**
     * @inheritDoc
     */
    public function getObjectTypeName()
    {
        return 'com.woltlab.wbb.post';
    }

    /**
     * @inheritDoc
     */
    public function getContainerTitle()
    {
        return BoardCache::getInstance()->getBoard($this->boardID)->getTitle();
    }

    /**
     * @inheritDoc
     */
    public function getContainerLink()
    {
        return BoardCache::getInstance()->getBoard($this->boardID)->getLink();
    }
}
