<?php

namespace wbb\system\ad\location;

use wbb\page\IThreadPage;
use wcf\system\ad\location\AbstractAdLocation;
use wcf\system\request\RequestHandler;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 * Ad location implementation for ads on pages belonging to threads.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Ad\Location
 * @since   5.2
 */
class ThreadAdLocation extends AbstractAdLocation
{
    /**
     * @inheritDoc
     */
    public function getVariablesDescription()
    {
        return WCF::getLanguage()->getDynamicVariable('wcf.acp.ad.location.thread.variables.description');
    }

    /**
     * @inheritDoc
     */
    public function replaceVariables($ad)
    {
        if (RequestHandler::getInstance()->getActiveRequest() !== null) {
            $requestObject = RequestHandler::getInstance()->getActiveRequest()->getRequestObject();
            if ($requestObject instanceof IThreadPage && $requestObject->getThread() !== null) {
                $ad = \strtr($ad, [
                    '{$boardTitle}' => StringUtil::encodeHTML($requestObject->getThread()->getBoard()->getTitle()),
                    '{$threadTitle}' => StringUtil::encodeHTML($requestObject->getThread()->getTitle()),
                ]);
            }
        }

        return $ad;
    }
}
