<?php

namespace wbb\system\bbcode;

use wbb\data\post\ViewablePost;
use wcf\system\bbcode\AbstractBBCode;
use wcf\system\bbcode\BBCodeParser;
use wcf\system\message\embedded\object\MessageEmbeddedObjectManager;
use wcf\system\request\LinkHandler;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 * Parses the [post] bbcode tag.
 *
 * @author      Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package     WoltLabSuite\Forum\System\Bbcode
 * @since       5.2
 */
class PostBBCode extends AbstractBBCode
{
    /**
     * @inheritDoc
     */
    public function getParsedTag(array $openingTag, $content, array $closingTag, BBCodeParser $parser)
    {
        $objectID = 0;
        if (isset($openingTag['attributes'][0])) {
            $objectID = \intval($openingTag['attributes'][0]);
        }

        /** @var ViewablePost $object */
        $object = MessageEmbeddedObjectManager::getInstance()->getObject('com.woltlab.wbb.post', $objectID);
        if ($object !== null && $object->canRead()) {
            if ($parser->getOutputType() == 'text/html') {
                return WCF::getTPL()->fetch('postBBCode', 'wbb', [
                    'post' => $object,
                    'postID' => $object->postID,
                    'titleHash' => \substr(StringUtil::getRandomID(), 0, 8),
                ], true);
            } else {
                return StringUtil::getAnchorTag(LinkHandler::getInstance()->getLink('Thread', [
                    'application' => 'wbb',
                    'object' => $object->getThread(),
                    'postID' => $object->postID,
                ]) . "#post{$object->postID}", $object->getTitle());
            }
        }

        return StringUtil::getAnchorTag(LinkHandler::getInstance()->getLink('Thread', [
            'application' => 'wbb',
            'postID' => $objectID,
        ]) . "#post{$objectID}");
    }
}
