<?php

namespace wbb\system\bulk\processing\post;

use wbb\data\post\PostAction;
use wbb\data\post\PostList;
use wcf\data\DatabaseObjectList;
use wcf\system\exception\InvalidObjectArgument;

/**
 * Default bulk processing action implementation for posts.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Bulk\Processing\Post
 * @since   5.0
 */
class PostBulkProcessingAction extends AbstractPostBulkProcessingAction
{
    /**
     * @inheritDoc
     */
    public function executeAction(DatabaseObjectList $objectList)
    {
        if (!($objectList instanceof PostList)) {
            throw new InvalidObjectArgument($objectList, PostList::class, 'Object list');
        }

        if (\count($objectList)) {
            /** @noinspection PhpUndefinedFieldInspection */
            $postAction = new PostAction($objectList->getObjects(), $this->object->action, [
                'isBulkProcessing' => true,
            ]);
            $postAction->executeAction();
        }
    }
}
