{include file='header' pageTitle='wbb.acp.board.'|concat:$action}

<link href="{@$__wcf->getPath('wbb')}acp/style/boardIcon.css" type="text/css" rel="stylesheet">

{include file='colorPickerJavaScript'}
{include file='fontAwesomeJavaScript'}

<script data-relocate="true">
	require(["WoltLabSuite/Core/Language", "WoltLabSuite/Forum/Acp/Ui/Board/Icon"], (Language, AcpUiBoardIcon) => {
		Language.addObject({
			'wbb.acp.board.icon.color': '{jslang}wbb.acp.board.icon{/jslang}',
			'wbb.acp.board.icon.name': '{jslang}wbb.acp.board.icon{/jslang}',
		});

		AcpUiBoardIcon.init();
	});
</script>

{include file='aclPermissions'}
<script data-relocate="true">
	$(function() {
		$('#boardTypeContainer input[type=radio]').change(function(event) {
			toggleContainers($(event.currentTarget).attr('value'));
		});

		function toggleContainers(boardType) {
			boardType = parseInt(boardType);

			switch (boardType) {
				case 0:
					$('#externalURLContainer').hide();
					showContainers('#propertiesContainer, #filterContainer, #styleContainer, #boardIconContainer, #threadFormSectionMenu');
				break;

				case 1:
					showContainers('#styleContainer');
					$('#externalURLContainer, #propertiesContainer, #filterContainer, #boardIconContainer, #threadFormSectionMenu').hide();
				break;

				case 2:
					showContainers('#externalURLContainer, #boardIconContainer');
					$('#propertiesContainer, #filterContainer, #styleContainer, #threadFormSectionMenu').hide();
				break;
			}

			toggleIcons(boardType);
		}

		function showContainers(selector) {
			var $containers = $(selector).show();
		}

		var container = elById('iconContainer');
		var iconContainers = [
			elBySel('dl[data-type="default"]', container),
			elBySel('dl[data-type="unread"]', container),
			elBySel('dl[data-type="closed"]', container),
			elBySel('dl[data-type="external"]', container)
		];
		function toggleIcons(boardType) {
			iconContainers.forEach(elHide);

			if (boardType === 0) {
				elShow(iconContainers[0]);
				elShow(iconContainers[1]);
				elShow(iconContainers[2]);
			}
			else if (boardType === 2) {
				elShow(iconContainers[3]);
			}
		}

		// set board type on init
		toggleContainers({@$boardType});

		WCF.Language.addObject({
			'wbb.acp.board.copy.confirmMessage': '{jslang}wbb.acp.board.copy.confirmMessage{/jslang}',
			'wbb.acp.board.copy.recursive': '{jslang}wbb.acp.board.copy.recursive{/jslang}',
			'wbb.acp.board.copy.recursive.description': '{jslang}wbb.acp.board.copy.recursive.description{/jslang}'
		});

		{if $action == 'edit'}
			new WBB.ACP.Board.Copy({@$boardID});
		{/if}
	});
</script>

{include file='multipleLanguageInputJavascript' elementIdentifier='description' forceSelection=false}
{include file='multipleLanguageInputJavascript' elementIdentifier='metaDescription' forceSelection=false}
{include file='multipleLanguageInputJavascript' elementIdentifier='title' forceSelection=false}

{if $boardID|isset}
	{include file='aclPermissionJavaScript' containerID='userPermissionsContainer' categoryName='user.*' objectID=$boardID}
	{include file='aclPermissionJavaScript' containerID='moderatorPermissionsContainer' categoryName='mod.*' objectID=$boardID}
{else}
	{include file='aclPermissionJavaScript' containerID='userPermissionsContainer' categoryName='user.*'}
	{include file='aclPermissionJavaScript' containerID='moderatorPermissionsContainer' categoryName='mod.*'}
{/if}

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.board.{$action}{/lang}</h1>
		{if $action == 'edit'}<p class="contentHeaderDescription">{$board->getTitle()}</p>{/if}
	</div>

	<nav class="contentHeaderNavigation">
		<ul>
			{if $action == 'edit'}
				{if $availableBoards->hasChildren()}
					<li class="dropdown">
						<a class="button dropdownToggle"><span class="icon icon16 fa-sort"></span> <span>{lang}wbb.acp.board.button.choose{/lang}</span></a>
						<div class="dropdownMenu">
							<ul class="scrollableDropdownMenu">
								{foreach from=$availableBoards item='availableBoard'}
									<li{if $availableBoard->getBoard()->boardID == $boardID} class="active"{/if}><a href="{link controller='BoardEdit' application='wbb' id=$availableBoard->getBoard()->boardID}{/link}">{section name=i loop=$availableBoards->getDepth()}&nbsp;&nbsp;&nbsp;&nbsp;{/section}{$availableBoard->getTitle()}</a></li>
								{/foreach}
							</ul>
						</div>
					</li>
				{/if}

				<li><a class="jsButtonBoardCopy button"><span class="icon icon16 fa-files-o"></span> <span>{lang}wbb.acp.board.button.copy{/lang}</span></a></li>
			{/if}
			<li><a href="{link application='wbb' controller='BoardList'}{/link}" class="button"><span class="icon icon16 fa-list"></span> <span>{lang}wbb.acp.menu.link.board.list{/lang}</span></a></li>

			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{include file='formNotice'}

<form method="post" action="{if $action == 'add'}{link application='wbb' controller='BoardAdd'}{/link}{else}{link application='wbb' controller='BoardEdit' id=$boardID}{/link}{/if}">
	<div class="section tabMenuContainer" data-active="{$activeTabMenuItem}" data-store="activeTabMenuItem">
		<nav class="tabMenu">
			<ul>
				<li><a href="#general">{lang}wbb.acp.board.category.general{/lang}</a></li>
				<li><a href="#userPermissions">{lang}wbb.acp.board.category.userPermissions{/lang}</a></li>
				<li><a href="#moderatorPermissions">{lang}wbb.acp.board.category.moderatorPermissions{/lang}</a></li>
				{event name='tabMenuTabs'}
			</ul>
		</nav>

		<div id="general" class="tabMenuContent">
			<div class="section">
				<dl id="boardTypeContainer" role="group" aria-labelledby="boardTypeLabel">
					<dt><label id="boardTypeLabel">{lang}wbb.acp.board.boardType{/lang}</label></dt>
					<dd class="floated">
						<label><input type="radio" name="boardType" value="0"{if $boardType == 0} checked{/if}> {lang}wbb.acp.board.boardType.board{/lang}</label>
						<label><input type="radio" name="boardType" value="1"{if $boardType == 1} checked{/if}> {lang}wbb.acp.board.boardType.category{/lang}</label>
						<label><input type="radio" name="boardType" value="2"{if $boardType == 2} checked{/if}> {lang}wbb.acp.board.boardType.externalLink{/lang}</label>
					</dd>
				</dl>

				<dl{if $errorField == 'title'} class="formError"{/if}>
					<dt><label for="title">{lang}wcf.global.title{/lang}</label></dt>
					<dd>
						<input type="text" id="title" name="title" value="{$i18nPlainValues['title']}" maxlength="255" class="medium">
						{if $errorField == 'title'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{elseif $errorType == 'multilingual'}
									{lang}wcf.global.form.error.multilingual{/lang}
								{else}
									{lang}wbb.acp.board.title.error.{@$errorType}{/lang}
								{/if}
							</small>
						{/if}
					</dd>
				</dl>

				<dl{if $errorField == 'description'} class="formError"{/if}>
					<dt><label for="description">{lang}wcf.global.description{/lang}</label></dt>
					<dd>
						<textarea id="description" name="description" cols="40" rows="10">{$i18nPlainValues[description]}</textarea>
						{if $errorField == 'description'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{else}
									{lang}wbb.acp.board.description.error.{@$errorType}{/lang}
								{/if}
							</small>
						{/if}
					</dd>
				</dl>
				<dl>
					<dt></dt>
					<dd>
						<label><input type="checkbox" name="descriptionUseHtml" value="1"{if $descriptionUseHtml} checked{/if}> {lang}wbb.acp.board.descriptionUseHtml{/lang}</label>
					</dd>
				</dl>

				<dl{if $errorField == 'metaDescription'} class="formError"{/if}>
					<dt><label for="metaDescription">{lang}wbb.acp.board.metaDescription{/lang}</label></dt>
					<dd>
						<input type="text" id="metaDescription" name="metaDescription" value="{$i18nPlainValues[metaDescription]}" class="long" maxlength="255">
						{if $errorField == 'metaDescription'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{else}
									{lang}wbb.acp.board.metaDescription.error.{@$errorType}{/lang}
								{/if}
							</small>
						{/if}
					</dd>
				</dl>
				<dl id="externalURLContainer"{if $errorField == 'externalURL'} class="formError"{/if}>
					<dt><label for="externalURL">{lang}wbb.acp.board.externalURL{/lang}</label></dt>
					<dd>
						<input id="externalURL" type="text" name="externalURL" value="{$externalURL}" class="long">
						{if $errorField == 'externalURL'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{else}
									{lang}wbb.acp.board.externalURL.error.{@$errorType}{/lang}
								{/if}
							</small>
						{/if}
					</dd>
				</dl>

				{event name='dataFields'}
			</div>

			<section class="section">
				<h2 class="sectionTitle">{lang}wbb.acp.board.category.position{/lang}</h2>

				{hascontent}
					<dl{if $errorField == 'parentID'} class="formError"{/if}>
						<dt><label for="parentID">{lang}wbb.acp.board.parentID{/lang}</label></dt>
						<dd>
							<select name="parentID" id="parentID">
								<option value="0">{lang}wcf.global.noSelection{/lang}</option>
								{content}
									{foreach from=$boardNodeList item=boardNode}
										{if !$boardNode->getBoard()->isExternalLink()}
											<option value="{@$boardNode->getBoard()->boardID}"{if $boardNode->getBoard()->boardID == $parentID} selected{/if}>{if $boardNode->getDepth() > 1}{@"&nbsp;&nbsp;&nbsp;&nbsp;"|str_repeat:($boardNode->getDepth() - 1)}{/if}{$boardNode->getTitle()}</option>
										{/if}
									{/foreach}
								{/content}
							</select>
							{if $errorField == 'parentID'}
								<small class="innerError">
									{lang}wbb.acp.board.parentID.error.{@$errorType}{/lang}
								</small>
							{/if}
						</dd>
					</dl>
				{/hascontent}

				<dl>
					<dt><label for="position">{lang}wbb.acp.board.position{/lang}</label></dt>
					<dd>
						<input type="number" id="position" name="position" value="{if $position}{@$position}{/if}" class="tiny" min="0">
						<small>{lang}wbb.acp.board.position.description{/lang}</small>
					</dd>
				</dl>

				<dl>
					<dt></dt>
					<dd>
						<label><input type="checkbox" name="isInvisible" value="1"{if $isInvisible} checked{/if}> {lang}wbb.acp.board.isInvisible{/lang}</label>
						<small>{lang}wbb.acp.board.isInvisible.description{/lang}</small>
					</dd>
				</dl>

				{event name='positionFields'}
			</section>

			<section class="section" id="propertiesContainer">
				<h2 class="sectionTitle">{lang}wbb.acp.board.properties{/lang}</h2>

				<dl>
					<dt></dt>
					<dd>
						<label><input type="checkbox" id="isClosed" name="isClosed" value="1"{if $isClosed} checked{/if}> {lang}wbb.acp.board.isClosed{/lang}</label>
						<label><input type="checkbox" id="countUserPosts" name="countUserPosts" value="1"{if $countUserPosts} checked{/if}> {lang}wbb.acp.board.countUserPosts{/lang}</label>
						<label><input type="checkbox" id="showSubBoards" name="showSubBoards" value="1"{if $showSubBoards} checked{/if}> {lang}wbb.acp.board.showSubBoards{/lang}</label>
						<label><input type="checkbox" id="searchable" name="searchable" value="1"{if $searchable} checked{/if}> {lang}wbb.acp.board.searchable{/lang}</label>
						<label><input type="checkbox" id="searchableForSimilarThreads" name="searchableForSimilarThreads" value="1"{if $searchableForSimilarThreads} checked{/if}> {lang}wbb.acp.board.searchableForSimilarThreads{/lang}</label>
						<label><input type="checkbox" id="ignorable" name="ignorable" value="1"{if $ignorable} checked{/if}> {lang}wbb.acp.board.ignorable{/lang}</label>
						{if WBB_MODULE_THREAD_MARKING_AS_DONE}<label><input type="checkbox" id="enableMarkingAsDone" name="enableMarkingAsDone" value="1"{if $enableMarkingAsDone} checked{/if}> {lang}wbb.acp.board.enableMarkingAsDone{/lang}</label>{/if}
						<label><input type="checkbox" id="enableBestAnswer" name="enableBestAnswer" value="1"{if $enableBestAnswer} checked{/if}> {lang}wbb.acp.board.enableBestAnswer{/lang}</label>
						<label><input type="checkbox" id="isPrivate" name="isPrivate" value="1"{if $isPrivate} checked{/if}> {lang}wbb.acp.board.isPrivate{/lang}</label>
						<small>{lang}wbb.acp.board.isPrivate.description{/lang}</small>
						{event name='properties'}
					</dd>
				</dl>

				{if $threadFormList|count}
					<dl{if $errorField == 'formID'} class="formError"{/if}>
						<dt><label for="formID">{lang}wbb.acp.board.threadForm{/lang}</label></dt>
						<dd>
							<select name="formID" id="formID">
								<option value="0">{lang}wcf.global.noSelection{/lang}</option>
								{foreach from=$threadFormList item=threadForm}
									<option value="{@$threadForm->formID}"{if $threadForm->formID == $formID} selected{/if}>{$threadForm->getTitle()}</option>
								{/foreach}
							</select>

							{if $errorField == 'formID'}
								<small class="innerError">{lang}wbb.acp.board.formID.error.{@$errorType}{/lang}</small>
							{/if}
						</dd>
					</dl>
				{/if}
			</section>

			<section class="section" id="filterContainer">
				<h2 class="sectionTitle">{lang}wbb.acp.board.filter{/lang}</h2>

				<dl{if $errorField == 'daysPrune'} class="formError"{/if}>
					<dt>
						<label for="daysPrune">{lang}wbb.board.filterByDate{/lang}</label>
					</dt>
					<dd>
						<select id="daysPrune" name="daysPrune">
							<option value="0">{lang}wcf.global.noSelection{/lang}</option>
							{foreach from=$availableDaysPrune item=$item}
								<option value="{@$item}"{if $daysPrune == $item} selected{/if}>{lang}wbb.board.filterByDate.{@$item}{/lang}</option>
							{/foreach}
						</select>
						{if $errorField == 'daysPrune'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{else}
									{lang}wbb.acp.board.daysPrune.error.{@$errorType}{/lang}
								{/if}
							</small>
						{/if}
					</dd>
				</dl>
				<dl{if $errorField == 'sortField'} class="formError"{/if}>
					<dt>
						<label for="sortField">{lang}wbb.acp.board.sortField{/lang}</label>
					</dt>
					<dd>
						<select id="sortField" name="sortField">
							<option value="">{lang}wcf.global.noSelection{/lang}</option>
							<option value="topic"{if $sortField == 'topic'} selected{/if}>{lang}wbb.thread.topic{/lang}</option>
							<option value="username"{if $sortField == 'username'} selected{/if}>{lang}wbb.thread.username{/lang}</option>
							<option value="time"{if $sortField == 'time'} selected{/if}>{lang}wbb.thread.time{/lang}</option>
							<option value="replies"{if $sortField == 'replies'} selected{/if}>{lang}wbb.thread.replies{/lang}</option>
							{if MODULE_LIKE}<option value="cumulativeLikes"{if $sortField == 'cumulativeLikes'} selected{/if}>{lang}wcf.like.cumulativeLikes{/lang}</option>{/if}
							<option value="views"{if $sortField == 'views'} selected{/if}>{lang}wbb.thread.views{/lang}</option>
							<option value="lastPostTime"{if $sortField == 'lastPostTime'} selected{/if}>{lang}wbb.thread.lastPostTime{/lang}</option>
							{event name='sortFieldOptions'}
						</select>
						<select id="sortOrder" name="sortOrder">
							<option value="">{lang}wcf.global.noSelection{/lang}</option>
							<option value="ASC"{if $sortOrder == 'ASC'} selected{/if}>{lang}wcf.global.sortOrder.ascending{/lang}</option>
							<option value="DESC"{if $sortOrder == 'DESC'} selected{/if}>{lang}wcf.global.sortOrder.descending{/lang}</option>
						</select>
						{if $errorField == 'sortField'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{else}
									{lang}wbb.acp.board.sortField.error.{@$errorType}{/lang}
								{/if}
							</small>
						{/if}
					</dd>
				</dl>
				<dl>
					<dt>
						<label for="postSortOrder">{lang}wbb.acp.board.postSortOrder{/lang}</label>
					</dt>
					<dd>
						<select name="postSortOrder" id="postSortOrder">
							<option value="">{lang}wcf.global.noSelection{/lang}</option>
							<option value="ASC"{if $postSortOrder == 'ASC'} selected{/if}>{lang}wcf.global.sortOrder.ascending{/lang}</option>
							<option value="DESC"{if $postSortOrder == 'DESC'} selected{/if}>{lang}wcf.global.sortOrder.descending{/lang}</option>
						</select>
					</dd>
				</dl>
				<dl>
					<dt>
						<label for="threadsPerPage">{lang}wbb.acp.board.threadsPerPage{/lang}</label>
					</dt>
					<dd>
						<input type="number" id="threadsPerPage" name="threadsPerPage" value="{if $threadsPerPage}{@$threadsPerPage}{/if}" class="tiny" min="0">
					</dd>
				</dl>
				<dl>
					<dt>
						<label for="postsPerPage">{lang}wbb.acp.board.postsPerPage{/lang}</label>
					</dt>
					<dd>
						<input type="number" id="postsPerPage" name="postsPerPage" value="{if $postsPerPage}{@$postsPerPage}{/if}" class="tiny" min="0">
					</dd>
				</dl>

				{event name='filterFields'}
			</section>

			<section class="section" id="styleContainer">
				<h2 class="sectionTitle">{lang}wbb.acp.board.styleSettings{/lang}</h2>

				<dl>
					<dt><label for="styleID">{lang}wbb.acp.board.style{/lang}</label></dt>
					<dd>
						<select id="styleID" name="styleID">
							<option value="0">{lang}wcf.global.noSelection{/lang}</option>
							{foreach from=$availableStyles item=style}
								<option value="{@$style->styleID}"{if $style->styleID == $styleID} selected{/if}>{$style->styleName}</option>
							{/foreach}
						</select>
						<small>{lang}wbb.acp.board.style.description{/lang}</small>
					</dd>
				</dl>

				{event name='styleFields'}
			</section>

			<section class="section" id="boardIconContainer">
				<h2 class="sectionTitle">{lang}wbb.acp.board.icon{/lang}</h2>

				<div id="iconContainer" class="row rowColGap">
					{foreach from=$iconData key=iconType item=iconSettings}
						<dl class="col-xs-12 col-md-4" data-type="{$iconType}">
							<dt>{lang}wbb.acp.board.icon.{$iconType}{/lang}</dt>
							<dd>
								<span class="icon icon64 fa-{$iconSettings[icon]} jsBoardIcon"{if $iconSettings[useColor]} style="color: {$iconSettings[color]}"{/if}></span>
								<a href="#" class="button small">{lang}wcf.global.button.edit{/lang}</a>

								<input type="hidden" name="iconData[{$iconType}][icon]" value="{$iconSettings[icon]}">
								<input type="hidden" name="iconData[{$iconType}][useColor]" value="{$iconSettings[useColor]}">
								<input type="hidden" name="iconData[{$iconType}][color]" value="{$iconSettings[color]}">
							</dd>
						</dl>
					{/foreach}
				</div>

				{event name='iconFields'}
			</section>

			{event name='sections'}
		</div>

		<div id="userPermissions" class="tabMenuContent">
			<div class="section">
				<dl id="userPermissionsContainer">
					<dt>{lang}wcf.acl.permissions{/lang}</dt>
					<dd></dd>
				</dl>
			</div>
		</div>

		<div id="moderatorPermissions" class="tabMenuContent">
			<div class="section">
				<dl id="moderatorPermissionsContainer">
					<dt>{lang}wcf.acl.user.permissions{/lang}</dt>
					<dd></dd>
				</dl>
			</div>
		</div>

		{event name='tabMenuContents'}
	</div>

	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
		{csrfToken}
	</div>
</form>

<div id="boardIconEditor" style="display: none;">
	<div class="box128">
		<span class="icon icon128 fa-folder-open-o jsBoardIcon"></span>
		<div>
			<dl>
				<dt>{lang}wbb.acp.board.icon.name{/lang}</dt>
				<dd>
					<span class="jsBoardIconName">folder-open-o</span>
					<a href="#" class="button small"><span class="icon icon16 fa-search"></span></a>
				</dd>
			</dl>
			<dl>
				<dt></dt>
				<dd><label><input type="checkbox" class="jsBoardIconUseColor"> {lang}wbb.acp.board.icon.useColor{/lang}</label></dd>
			</dl>
			<dl class="jsBoardIconColorContainer">
				<dt>{lang}wbb.acp.board.icon.color{/lang}</dt>
				<dd>
					<span class="colorBox">
						<span class="colorBoxValue jsColorPicker" data-store="boardIcon_value"></span>
						<input type="hidden" id="boardIcon_value">
					</span>
					<a href="#" class="button small jsButtonOpenColorPicker"><span class="icon icon16 fa-paint-brush"></span></a>
				</dd>
			</dl>
		</div>
	</div>

	<div class="formSubmit">
		<button class="buttonPrimary">{lang}wcf.global.button.save{/lang}</button>
	</div>
</div>

{include file='footer'}
