{* default values *}
{if !$enableEditMode|isset}{assign var='enableEditMode' value=true}{/if}
{if !$enableWatchMode|isset}{assign var='enableWatchMode' value=false}{/if}
{if !$showBoardLink|isset}{assign var='showBoardLink' value=false}{/if}
{if !$showDividers|isset}{assign var='showDividers' value=false}{/if}
{if !$forceIsNew|isset}{assign var='forceIsNew' value=false}{/if}
{assign var='showLanguageFlag' value=false}
{if $__wcf->user->getLanguageIDs()|count > 1}{assign var='showLanguageFlag' value=true}{/if}

{foreach from=$objects item=thread}
	<li class="tabularListRow{if $showDividers && ($thread->isAnnouncement || $thread->isSticky)} divider{/if}">
		<ol
			id="thread{@$thread->threadID}"
			class="tabularListColumns messageGroup wbbThread jsClipboardObject{if $thread->isNew()} new{/if}{if $thread->isDisabled} messageDisabled{/if}{if $thread->isDeleted} messageDeleted{/if}{if $thread->isAnnouncement} wbbThreadAnnouncement{/if}{if $thread->isSticky} wbbThreadSticky{/if}{if $__wcf->getUserProfileHandler()->isIgnoredUser($thread->userID, 2)} ignoredUserContent{/if}"
			data-thread-id="{@$thread->threadID}" data-element-id="{@$thread->threadID}" data-is-closed="{@$thread->isClosed}" data-is-deleted="{@$thread->isDeleted}"
			data-is-sticky="{@$thread->isSticky}" data-is-disabled="{@$thread->isDisabled}" data-is-announcement="{@$thread->isAnnouncement}"
			{if WBB_MODULE_THREAD_MARKING_AS_DONE && $thread->getBoard()->enableMarkingAsDone} data-is-done="{@$thread->isDone}" data-can-mark-as-done="{if $thread->canMarkAsDone()}1{else}0{/if}"{/if}
			data-is-link="{if $thread->movedThreadID}1{else}0{/if}"
		>
			{if $enableEditMode && (($board|isset && $board->canEditThreads()) || (!$board|isset && $thread->getBoard()->canEditThreads()))}
				<li class="columnMark jsOnly">
					<label><input type="checkbox" class="jsClipboardItem" data-object-id="{@$thread->threadID}"></label>
				</li>
			{/if}
			{if $enableWatchMode}
				<li class="columnMark jsOnly">
					<label><input type="checkbox" class="jsWatchedThread" data-object-id="{@$thread->threadID}"></label>
				</li>
			{/if}
			<li class="columnIcon columnAvatar">
				<div>
					<p{if $thread->isNew()} title="{lang}wbb.thread.markAsRead.doubleClick{/lang}"{/if}>{@$thread->getUserProfile()->getAvatar()->getImageTag(48)}</p>
					
					{if $thread->ownPosts && $thread->userID != $__wcf->user->userID}
						{if $__wcf->getUserProfileHandler()->getAvatar()}
							<small class="myAvatar jsTooltip" title="{lang}wbb.thread.ownPosts{/lang}">{@$__wcf->getUserProfileHandler()->getAvatar()->getImageTag(24)}</small>
						{/if}
					{/if}
			
					{if $thread->movedThreadID}
						<span class="icon icon16 fa-arrow-right jsTooltip wbbMovedIcon" title="{lang}wbb.thread.moved{/lang}"></span>
					{else}
						{if $thread->isAnnouncement}<span class="icon icon16 fa-bullhorn jsTooltip wbbAnnouncementIcon" title="{lang}wbb.thread.announcement{/lang}"></span>{/if}
						{if $thread->isSticky}<span class="icon icon16 fa-thumb-tack jsTooltip wbbStickyIcon" title="{lang}wbb.thread.sticky{/lang}"></span>{/if}
					{/if}
					
					{event name='icons'}
				</div>
			</li>
			{if $thread->isDeleted && !$thread->getBoard()->getModeratorPermission('canReadDeletedThread')}
				<li class="columnSubject">
					<h3>
						<span class="messageGroupLink">{$thread->topic}</span>
					</h3>
					
					<ul class="inlineList dotSeparated small messageGroupInfo">
						<li class="messageGroupAuthor">{user object=$thread->getUserProfile()}</li>
						<li class="messageGroupTime">{@$thread->time|time}</li>
					</ul>
					
					{if $thread->getDeleteNote()}
						<small class="wbbThreadDeleteNote">
							{@$thread->getDeleteNote()}
						</small>
					{/if}
				</li>
			{else}
				<li class="columnSubject">
					{hascontent}
						<ul class="labelList">
							{content}
								{event name='beforeLabels'}
								{foreach from=$thread->getLabels() item=label}
									<li><a href="{link application='wbb' controller='Board' object=$thread->getBoard()}labelIDs[{@$label->groupID}]={@$label->labelID}{/link}" class="badge label{if $label->getClassNames()} {$label->getClassNames()}{/if} jsTooltip" title="{lang}wbb.thread.labeledThreads{/lang}">{$label->getTitle()}</a></li>
								{/foreach}
								{event name='afterLabels'}
							{/content}
						</ul>
					{/hascontent}
					
					<h3>
						{event name='badges'}
						
						{if $thread->movedThreadID}
							{anchor object=$thread->getMovedThread() class='wbbTopicLink messageGroupLink'}
						{else}
							{if ($forceIsNew || $thread->isNew()) && $__wcf->user->userID}
								<a href="{link application='wbb' controller='Thread' object=$thread}action=firstNew{/link}" class="messageGroupLink{if $thread->getBoard()->getPermission('canReadThread')} wbbTopicLink{/if}" data-object-id="{@$thread->threadID}">{$thread->topic}</a>
							{else}
								<a href="{$thread->getLink()}" class="messageGroupLink{if $thread->getBoard()->getPermission('canReadThread')} wbbTopicLink{/if}" data-object-id="{@$thread->threadID}">{$thread->topic}</a>
							{/if}
						{/if}
						
						{if $thread->replies}
							<span class="badge messageGroupCounterMobile">{@$thread->replies|shortUnit}</span>
						{/if}
					</h3>
					
					<aside class="statusDisplay" role="presentation">
						<ul class="inlineList statusIcons">
							{if MODULE_LIKE && $__wcf->getSession()->getPermission('user.like.canViewLike') && !$thread->movedThreadID && $thread->cumulativeLikes}<li>{include file='__topReaction' cachedReactions=$thread->cachedReactions render='short'}</li>{/if}
							{if $thread->isDisabled && $thread->enableTime}<li><span class="icon icon16 fa-clock-o jsTooltip" title="{lang}wbb.thread.delayedPublication{/lang}"></span></li>{/if}
							{if $thread->reportQueueID}<li><a href="{link controller='ModerationReport' id=$thread->reportQueueID}{/link}"><span class="icon icon16 fa-exclamation-triangle jsTooltip" title="{lang}wbb.thread.reported{/lang}"></span></a></li>{/if}
							{if $thread->isClosed}<li><span class="icon icon16 fa-lock jsIconClosed jsTooltip" title="{lang}wbb.thread.closed{/lang}"></span></li>{/if}
							{if $thread->polls}<li><span class="icon icon16 fa-bar-chart jsTooltip" title="{lang}wbb.thread.polls{/lang}"></span></li>{/if}
							{if $thread->attachments}<li><span class="icon icon16 fa-paperclip jsTooltip" title="{lang}wbb.thread.attachments{/lang}"></span></li>{/if}
							
							{if WBB_MODULE_THREAD_MARKING_AS_DONE && $thread->getBoard()->enableMarkingAsDone}
								<li>
									{if $thread->isDone}
										<span class="icon icon16 fa-check-square-o jsTooltip jsMarkAsDone" title="{lang}wbb.thread.done{/lang}"></span>
									{else}
										<span class="icon icon16 fa-square-o jsTooltip jsMarkAsDone" title="{lang}wbb.thread.undone{/lang}"></span>
									{/if}
								</li>
							{/if}
							
							{event name='statusIcons'}
							
							{if WBB_BOARD_THREADS_ENABLE_LANGUAGE_FLAG && $showLanguageFlag && $thread->getLanguage()}<li><a href="{link application='wbb' controller='Board' object=$thread->getBoard()}languageID={@$thread->languageID}{/link}" class="jsTooltip" title="{lang}wbb.thread.languageFilter{/lang}">{@$thread->getLanguageIcon()}</a></li>{/if}
						</ul>
					</aside>
					
					<ul class="inlineList dotSeparated small messageGroupInfo">
						<li class="messageGroupAuthor">{user object=$thread->getUserProfile()}</li>
						<li class="messageGroupTime">{@$thread->time|time}</li>
						{if $enableEditMode && $thread->getBoard()->canEditThreads()}<li class="messageGroupEditLink jsOnly"><a href="#" class="jsThreadInlineEditor">{lang}wcf.global.button.edit{/lang}</a></li>{/if}
						{if $showBoardLink}<li class="wbbThreadBoardLink"><a href="{link application='wbb' controller='Board' object=$thread->getBoard()}{/link}">{$thread->getBoard()->getTitle()}</a></li>{/if}
						{event name='messageGroupInfo'}
					</ul>
					
					<ul class="messageGroupInfoMobile">
						<li class="messageGroupAuthorMobile">{$thread->getUserProfile()->username}</li>
						<li class="messageGroupLastPostTimeMobile">{@$thread->lastPostTime|time}</li>
					</ul>
					
					{if $thread->isDeleted && $thread->getDeleteNote()}
						<small class="wbbThreadDeleteNote">
							{@$thread->getDeleteNote()}
						</small>
					{/if}
					
					{event name='threadData'}
				</li>
				<li class="columnStats">
					<dl class="plain statsDataList">
						<dt>{lang}wbb.thread.replies{/lang}</dt>
						<dd>{@$thread->replies|shortUnit}</dd>
					</dl>
					<dl class="plain statsDataList">
						<dt>{lang}wbb.thread.views{/lang}</dt>
						<dd>{@$thread->views|shortUnit}</dd>
					</dl>
					
					<div class="messageGroupListStatsSimple">{if $thread->replies}<span class="icon icon16 fa-comment-o" aria-label="{lang}wbb.thread.replies{/lang}"></span> {@$thread->replies|shortUnit}{/if}</div>
				</li>
				
				<li class="columnLastPost">
					{if $thread->replies != 0}
						<div class="box32{if $__wcf->getUserProfileHandler()->isIgnoredUser($thread->getLastPosterProfile()->userID, 2)} ignoredUserContent{/if}">
							<a href="{if $thread->movedThreadID}{link application='wbb' controller='Thread' object=$thread->getMovedThread()}action=lastPost{/link}{else}{link application='wbb' controller='Thread' object=$thread}action=lastPost{/link}{/if}" class="jsTooltip" title="{lang}wbb.thread.gotoLastPost{/lang}">{@$thread->getLastPosterProfile()->getAvatar()->getImageTag(32)}</a>
							
							<div>
								<p>
									{user object=$thread->getLastPosterProfile()}
								</p>
								<small>{@$thread->lastPostTime|time}</small>
							</div>
						</div>
					{/if}
				</li>
			{/if}
			
			{event name='columns'}
		</ol>
	</li>
{/foreach}
