{capture assign='pageTitle'}{lang}wbb.post.userPosts{/lang}{if $pageNo > 1} - {lang}wcf.page.pageNo{/lang}{/if}{/capture}
{capture assign='contentTitle'}{lang}wbb.post.userPosts{/lang}{/capture}

{capture assign='headContent'}
	{if $pageNo < $pages}
		<link rel="next" href="{link application='wbb' controller='UserPostList' object=$user}pageNo={@$pageNo+1}{/link}">
	{/if}
	{if $pageNo > 1}
		<link rel="prev" href="{link application='wbb' controller='UserPostList' object=$user}{if $pageNo > 2}pageNo={@$pageNo-1}{/if}{/link}">
	{/if}
{/capture}

{capture assign='contentInteractionPagination'}
	{pages print=true assign=pagesLinks application='wbb' controller='UserPostList' object=$user link="pageNo=%d"}
{/capture}

{include file='header'}

{if $items}
	<div class="section">
		<ul class="messageList messageReducedList jsClipboardContainer" data-type="com.woltlab.wbb.post">
			{foreach from=$objects item=post}
				{if $post->getThread()->getBoard()->getModeratorPermission('canClosePost') || $post->getThread()->getBoard()->getModeratorPermission('canDeletePost') || $post->getThread()->getBoard()->getModeratorPermission('canDeletePostCompletely') || $post->getThread()->getBoard()->getModeratorPermission('canEnablePost') || $post->getThread()->getBoard()->getModeratorPermission('canRestorePost')}
					{assign var='canEditPostInline' value=true}
				{else}
					{assign var='canEditPostInline' value=false}
				{/if}
				
				<li>
					<article class="wbbPost message messageReduced jsClipboardObject jsMessage"
					         data-object-id="{@$post->postID}" data-post-id="{@$post->postID}" data-can-edit="0" data-can-edit-inline="1"
					         data-is-closed="{if $post->isClosed}1{else}0{/if}" data-is-deleted="{if $post->isDeleted}1{else}0{/if}" data-is-disabled="{if $post->isDisabled}1{else}0{/if}"
					         data-can-close="{@$post->getThread()->getBoard()->getModeratorPermission('canClosePost')}" data-can-delete="{@$post->getThread()->getBoard()->getModeratorPermission('canDeletePost')}" data-can-delete-completely="{@$post->getThread()->getBoard()->getModeratorPermission('canDeletePostCompletely')}" data-can-enable="{@$post->getThread()->getBoard()->getModeratorPermission('canEnablePost')}" data-can-restore="{@$post->getThread()->getBoard()->getModeratorPermission('canRestorePost')}"
					>
						<div class="messageContent">
							<header class="messageHeader">
								<div class="box32 messageHeaderWrapper">
									{user object=$post->getUserProfile() type='avatar32' ariaHidden='true' tabindex='-1'}
									
									<div class="messageHeaderBox">
										<h2 class="messageTitle">
											<a href="{link application='wbb' controller='Thread' object=$post->getThread()}postID={@$post->postID}{/link}#post{@$post->postID}">{$post->getThread()->topic}</a>
										</h2>
										
										<ul class="messageHeaderMetaData">
											<li>{user object=$post->getUserProfile() class='username'}</li>
											<li><a href="{link application='wbb' controller='Thread' object=$post->getThread()}postID={@$post->postID}{/link}#post{@$post->postID}" class="permalink messagePublicationTime">{@$post->time|time}</a></li>
											
											{event name='messageHeaderMetaData'}
										</ul>
										
										<ul class="messageStatus">
											{if $post->isDeleted}<li><span class="badge label red jsIconDeleted">{lang}wcf.message.status.deleted{/lang}</span></li>{/if}
											{if $post->isDisabled}<li><span class="badge label green jsIconDisabled">{lang}wcf.message.status.disabled{/lang}</span></li>{/if}
											
											{event name='messageStatus'}
										</ul>
									</div>
								</div>
								
								<ul class="messageQuickOptions">
									{if $post->reportQueueID}
										<li><a href="{link controller='ModerationReport' id=$post->reportQueueID}{/link}"><span class="icon icon16 fa-exclamation-triangle jsTooltip" title="{lang}wbb.post.reported{/lang}"></span></a></li>
									{/if}
									
									{if $post->isClosed}
										<li class="wbbPostClosed"><span class="jsTooltip icon icon16 fa-lock" title="{lang}wbb.post.closed{/lang}"></span></li>
									{/if}
									
									{if $canEditPostInline && $__wcf->getSession()->getPermission('mod.board.canEditPost')}
										<li class="jsOnly"><label class="messageClipboardCheckbox"><input type="checkbox" class="jsClipboardItem" data-object-id="{@$post->postID}"></label></li>
									{/if}
									
									{event name='messageQuickOptions'}
								</ul>
								
								{event name='messageHeader'}
							</header>
							
							<div class="messageBody">
								{event name='beforeMessageText'}
								
								<div class="messageText">
									{@$post->getFormattedMessage()}
								</div>
								
								{event name='afterMessageText'}
							</div>
							
							<footer class="messageFooter">
								{include file='attachments' objectID=$post->postID}
								
								{event name='messageFooter'}
								
								<div class="messageFooterNotes">
									{if $post->isDeleted}
										<p class="messageFooterNote wbbPostDeleteNote">{@$post->getDeleteNote()}</p>
									{/if}
									
									{event name='messageFooterNotes'}
								</div>
								
								<div class="messageFooterGroup">
									<ul class="messageFooterButtons buttonList smallButtons jsMobileNavigation">
										{if $canEditPostInline}
											<li><a href="#" title="{lang}wbb.post.edit{/lang}" class="button jsMessageEditButton"><span class="icon icon16 fa-pencil"></span> <span>{lang}wcf.global.button.edit{/lang}</span></a></li>
										{/if}
										{event name='messageFooterButtons'}
									</ul>
								</div>
							</footer>
						</div>
					</article>
				</li>
			{/foreach}
		</ul>
	</div>
	
	{if $__wcf->getSession()->getPermission('mod.board.canEditPost')}
		<script data-relocate="true">
			require(['Language', 'WoltLabSuite/Forum/Ui/Post/List/Mixed'], function (Language, UiPostListMixed) {
				Language.addObject({
					'wbb.post.edit.close': '{jslang}wbb.post.edit.close{/jslang}',
					'wbb.post.edit.delete': '{jslang}wbb.post.edit.trash{/jslang}',
					'wbb.post.edit.delete.confirmMessage': '{jslang}wbb.post.edit.delete.confirmMessage{/jslang}',
					'wbb.post.edit.deleteCompletely': '{jslang}wbb.post.edit.delete{/jslang}',
					'wbb.post.edit.open': '{jslang}wbb.post.edit.open{/jslang}',
					'wbb.post.edit.restore': '{jslang}wbb.post.edit.restore{/jslang}',
					'wbb.post.edit.disable': '{jslang}wbb.post.edit.disable{/jslang}',
					'wbb.post.edit.enable': '{jslang}wbb.post.edit.enable{/jslang}',
					'wbb.post.edit.trash.confirmMessage': '{jslang}wbb.post.edit.trash.confirmMessage{/jslang}',
					'wbb.post.edit.trash.reason': '{jslang}wbb.post.edit.trash.reason{/jslang}',
					'wcf.message.status.deleted': '{jslang}wcf.message.status.deleted{/jslang}',
					'wcf.message.status.disabled': '{jslang}wcf.message.status.disabled{/jslang}'
				});
				
				UiPostListMixed.init();
			});
		</script>
	{/if}
{else}
	<p class="info" role="status">{lang}wcf.global.noItems{/lang}</p>
{/if}

<footer class="contentFooter">
	{hascontent}
		<div class="paginationBottom">
			{content}{@$pagesLinks}{/content}
		</div>
	{/hascontent}
	
	{hascontent}
		<nav class="contentFooterNavigation">
			<ul>
				{content}
					{event name='contentFooterNavigation'}
				{/content}
			</ul>
		</nav>
	{/hascontent}
</footer>

{include file='footer'}
