<?php

namespace wbb\system\event\listener;

use wcf\system\box\ArticleListBoxController;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\WCF;

/**
 * Provides the 'replies' sort field for article boxes.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 */
class ArticleListBoxControllerListener implements IParameterizedEventListener
{
    /**
     * @inheritDoc
     */
    public function execute($eventObj, $className, $eventName, array &$parameters)
    {
        /** @var ArticleListBoxController $eventObj */

        if ($eventName === '__construct') {
            $eventObj->validSortFields[] = 'replies';
        } elseif ($eventName === 'readObjects') {
            if ($eventObj->sortField === 'replies') {
                $sqlSelectReplies = "(
                    SELECT  (
                                SELECT  thread.replies
                                FROM    wbb" . WCF_N . "_thread thread
                                WHERE   thread.threadID = article_content.articleThreadID
                            ) AS threadReplies
                    FROM    wcf" . WCF_N . "_article_content article_content
                    WHERE   article_content.articleID = article.articleID
                        AND (
                                    article_content.languageID IS NULL
                                 OR article_content.languageID = " . WCF::getLanguage()->languageID . "
                            )
                )";

                if (!empty($eventObj->objectList->sqlSelects)) {
                    $eventObj->objectList->sqlSelects .= ',';
                }
                $eventObj->objectList->sqlSelects .= "{$sqlSelectReplies} AS replies";

                $eventObj->objectList->getConditionBuilder()->add("{$sqlSelectReplies} > ?", [0]);
            }
        }
    }
}
