<?php

namespace wbb\data\modification\log;

use wbb\system\cache\runtime\ThreadRuntimeCache;
use wcf\data\modification\log\ModificationLogAction;
use wcf\data\modification\log\ModificationLogEditor;
use wcf\data\object\type\ObjectTypeCache;
use wcf\system\exception\IllegalLinkException;
use wcf\system\exception\PermissionDeniedException;

/**
 * Executes thread modification log related actions.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Modification\Log
 */
class ThreadModificationLogAction extends ModificationLogAction
{
    /**
     * @inheritDoc
     */
    public $className = ModificationLogEditor::class;

    /**
     * Validates the `hide` action.
     *
     * @throws PermissionDeniedException
     * @throws IllegalLinkException
     */
    public function validateHide()
    {
        if (empty($this->objects)) {
            $this->readObjects();
        }

        foreach ($this->getObjects() as $object) {
            $thread = ThreadRuntimeCache::getInstance()->getObject($object->objectID);

            if (
                !$thread
                || $object->objectTypeID != ObjectTypeCache::getInstance()->getObjectTypeIDByName('com.woltlab.wcf.modifiableContent', 'com.woltlab.wbb.thread')
            ) {
                throw new IllegalLinkException();
            }

            if (!$thread->canRead() || !$thread->getBoard()->getModeratorPermission('canEditPost')) {
                throw new PermissionDeniedException();
            }
        }
    }

    /**
     * Hides an entry for the thread log.
     *
     * @return int[]
     */
    public function hide()
    {
        if (empty($this->objects)) {
            $this->readObjects();
        }

        foreach ($this->getObjects() as $object) {
            $object->update([
                'hidden' => 1,
            ]);
        }

        return [
            'logIDs' => $this->getObjectIDs(),
        ];
    }
}
