<?php

namespace wbb\system\option;

use wbb\data\board\BoardCache;
use wbb\data\board\BoardNodeList;
use wcf\data\option\Option;
use wcf\system\exception\UserInputException;
use wcf\system\option\AbstractOptionType;
use wcf\system\WCF;

/**
 * Option type implementation for select lists.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Option
 */
class WBBBoardSelectOptionType extends AbstractOptionType
{
    /**
     * @inheritDoc
     */
    public function getFormElement(Option $option, $value)
    {
        // get searchable boards
        $boardNodeList = new BoardNodeList();
        $boardNodeList->readNodeTree();

        WCF::getTPL()->assign([
            'boardNodeList' => $boardNodeList->getNodeList(),
            'option' => $option,
            'value' => $value,
        ]);

        return WCF::getTPL()->fetch('boardSelectOptionType', 'wbb');
    }

    /**
     * @inheritDoc
     */
    public function validate(Option $option, $newValue)
    {
        if (!empty($newValue)) {
            if (BoardCache::getInstance()->getBoard(\intval($newValue)) === null) {
                throw new UserInputException($option->optionName, 'validationFailed');
            }
        }
    }

    /**
     * @inheritDoc
     */
    public function getData(Option $option, $newValue)
    {
        return \intval($newValue);
    }
}
