/**
 * Initializes modules required for thread view.
 *
 * @author  Alexander Ebert
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Controller/Thread
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Controller/Clipboard", "WoltLabSuite/Core/Ui/Reaction/Handler", "../Ui/Post/InlineEditor", "../Ui/Post/Loader", "../Ui/Post/Manager"], function (require, exports, tslib_1, ControllerClipboard, Handler_1, InlineEditor_1, UiPostLoader, Manager_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getPostManager = exports.getPostInlineEditor = exports.getPostLikeHandler = exports.init = void 0;
    ControllerClipboard = tslib_1.__importStar(ControllerClipboard);
    Handler_1 = tslib_1.__importDefault(Handler_1);
    InlineEditor_1 = tslib_1.__importDefault(InlineEditor_1);
    UiPostLoader = tslib_1.__importStar(UiPostLoader);
    Manager_1 = tslib_1.__importDefault(Manager_1);
    let _likeHandler = null;
    let _postInlineEditor = null;
    let _postManager = null;
    let _threadId = 0;
    /**
     * Initializes the thread view.
     */
    function init(threadId, modules, options) {
        _threadId = threadId;
        if (modules.clipboard) {
            ControllerClipboard.setup({
                hasMarkedItems: options.clipboard.hasMarkedItems,
                pageClassName: "wbb\\page\\ThreadPage",
                pageObjectId: _threadId,
            });
        }
        if (modules.postLikeHandler) {
            _likeHandler = new Handler_1.default("com.woltlab.wbb.likeablePost", {
                containerSelector: ".wbbPost:not(.messageCollapsed)",
            });
        }
        if (modules.postManager) {
            _postManager = new Manager_1.default(threadId);
            if (modules.postInlineEditor) {
                _postInlineEditor = new InlineEditor_1.default(_threadId, _postManager, options.postInlineEditor);
            }
            if (modules.postLoader) {
                UiPostLoader.init(_postManager, _postInlineEditor);
            }
        }
    }
    exports.init = init;
    /**
     * Returns the like handler for posts or null if disabled.
     */
    function getPostLikeHandler() {
        return _likeHandler;
    }
    exports.getPostLikeHandler = getPostLikeHandler;
    /**
     * Returns the InlineEditor instance for posts or null if disabled.
     */
    function getPostInlineEditor() {
        return _postInlineEditor;
    }
    exports.getPostInlineEditor = getPostInlineEditor;
    /**
     * Returns the Manager instance for posts or null if disabled.
     */
    function getPostManager() {
        return _postManager;
    }
    exports.getPostManager = getPostManager;
});
